/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.api.model.resource.model;

import java.util.ArrayList;
import java.util.List;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class Node {
    private final String name;
    private final Node parent;
    private boolean visible = true;
    private final Matrix4f initialTransform;
    private final Matrix4f relativeTransform;
    private final List<Node> children = new ArrayList<Node>();
    private final List<Integer> meshIndexes = new ArrayList<Integer>();

    public Node(String name, Matrix4f transformation, Node parent) {
        this.name = name;
        this.parent = parent;
        this.initialTransform = new Matrix4f((Matrix4fc)transformation);
        this.relativeTransform = transformation;
        if (parent != null) {
            parent.children.add(this);
        }
    }

    public Node findNode(String name) {
        for (Node child : this.children) {
            if (!child.name.equals(name)) continue;
            return child;
        }
        for (Node child : this.children) {
            Node foundNode = child.findNode(name);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Node getParent() {
        return this.parent;
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public List<Integer> getMeshIndexes() {
        return this.meshIndexes;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Matrix4f getInitialTransform() {
        return this.initialTransform;
    }

    public Matrix4f getRelativeTransform() {
        return this.relativeTransform;
    }

    public Matrix4f getInitialGlobalTransform() {
        Matrix4f globalTransform = new Matrix4f();
        if (this.getParent() != null) {
            globalTransform.mul((Matrix4fc)this.getParent().getInitialGlobalTransform());
        }
        globalTransform.mul((Matrix4fc)this.getInitialTransform());
        return globalTransform;
    }

    public Matrix4f getGlobalTransform() {
        Matrix4f globalTransform = new Matrix4f();
        if (this.getParent() != null) {
            globalTransform.mul((Matrix4fc)this.getParent().getGlobalTransform());
        }
        globalTransform.mul((Matrix4fc)this.getRelativeTransform());
        return globalTransform;
    }

    public void setLocalTransform(Matrix4f transform) {
        this.initialTransform.mul((Matrix4fc)transform, this.relativeTransform);
    }

    public Matrix4f getLocalTransform() {
        return this.relativeTransform.mul((Matrix4fc)new Matrix4f((Matrix4fc)this.initialTransform).invert(), new Matrix4f());
    }
}

