/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import me.pandamods.pandalib.PandaLib;
import me.pandamods.pandalib.api.config.ConfigData;
import me.pandamods.pandalib.api.config.PandaLibConfig;
import me.pandamods.pandalib.api.config.holders.ClientConfigHolder;
import me.pandamods.pandalib.api.config.holders.CommonConfigHolder;
import me.pandamods.pandalib.api.util.NetworkHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ConfigNetworking {
    public static final ResourceLocation CONFIG_PACKET = PandaLib.LOCATION("config_sync");

    public static void registerPackets() {
        NetworkHelper.registerS2C(CONFIG_PACKET, ConfigNetworking::CommonConfigReceiver);
        NetworkHelper.registerC2S(CONFIG_PACKET, ConfigNetworking::ClientConfigReceiver);
    }

    public static void SyncCommonConfigs(ServerPlayer serverPlayer) {
        PandaLibConfig.getConfigs().values().stream().filter(configHolder -> configHolder instanceof CommonConfigHolder && configHolder.shouldSynchronize()).forEach(configHolder -> ConfigNetworking.SyncCommonConfig(serverPlayer, (CommonConfigHolder)configHolder));
    }

    public static void SyncCommonConfig(ServerPlayer serverPlayer, CommonConfigHolder<?> holder) {
        holder.logger.info("Sending common config '{}' to {}", (Object)holder.resourceLocation().toString(), (Object)serverPlayer.m_5446_().getString());
        FriendlyByteBuf byteBuf = new FriendlyByteBuf(Unpooled.buffer());
        byteBuf.m_130085_(holder.resourceLocation());
        byteBuf.m_130070_(holder.getGson().toJson(holder.get()));
        NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (ResourceLocation)CONFIG_PACKET, (FriendlyByteBuf)byteBuf);
    }

    public static void SyncClientConfigs() {
        PandaLibConfig.getConfigs().values().stream().filter(configHolder -> configHolder instanceof ClientConfigHolder && configHolder.shouldSynchronize()).forEach(configHolder -> ConfigNetworking.SyncClientConfig((ClientConfigHolder)configHolder));
    }

    public static void SyncClientConfig(ClientConfigHolder<?> holder) {
        holder.logger.info("Sending client config '{}' to server", (Object)holder.resourceLocation().toString());
        FriendlyByteBuf byteBuf = new FriendlyByteBuf(Unpooled.buffer());
        byteBuf.m_130085_(holder.resourceLocation());
        byteBuf.m_130070_(holder.getGson().toJson(holder.get()));
        NetworkManager.sendToServer((ResourceLocation)CONFIG_PACKET, (FriendlyByteBuf)byteBuf);
    }

    private static void ClientConfigReceiver(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        ResourceLocation resourceLocation = buf.m_130281_();
        PandaLibConfig.getConfig(resourceLocation).ifPresent(configHolder -> {
            if (configHolder instanceof ClientConfigHolder) {
                ClientConfigHolder clientConfigHolder = (ClientConfigHolder)configHolder;
                configHolder.logger.info("Received client config '{}' from {}", (Object)configHolder.resourceLocation().toString(), (Object)context.getPlayer().m_5446_().getString());
                clientConfigHolder.putConfig(context.getPlayer(), (ConfigData)configHolder.getGson().fromJson(buf.m_130277_(), configHolder.getConfigClass()));
            }
        });
    }

    private static void CommonConfigReceiver(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        ResourceLocation resourceLocation = buf.m_130281_();
        PandaLibConfig.getConfig(resourceLocation).ifPresent(configHolder -> {
            if (configHolder instanceof CommonConfigHolder) {
                CommonConfigHolder commonConfigHolder = (CommonConfigHolder)configHolder;
                configHolder.logger.info("Received common config '{}' from server", (Object)configHolder.resourceLocation().toString());
                commonConfigHolder.setCommonConfig((ConfigData)configHolder.getGson().fromJson(buf.m_130277_(), configHolder.getConfigClass()));
            }
        });
    }
}

