/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.utils;

import org.joml.Matrix3dc;
import org.joml.Matrix3fc;
import org.joml.Matrix4dc;
import org.joml.Matrix4fc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2dc;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3ic;
import org.joml.Vector4dc;
import org.joml.Vector4fc;
import org.joml.Vector4ic;

public class PrintUtils {
    public static String getVector2String(Vector2fc vector) {
        return PrintUtils.getVector2String(vector.x(), vector.y());
    }

    public static String getVector2String(Vector2dc vector) {
        return PrintUtils.getVector2String(vector.x(), vector.y());
    }

    public static String getVector2String(Vector2ic vector) {
        return PrintUtils.getVector2String(vector.x(), vector.y());
    }

    public static String getVector2String(double x, double y) {
        return "Vector2[" + x + ", " + y + "]";
    }

    public static String getVector3String(Vector3fc vector) {
        return PrintUtils.getVector3String(vector.x(), vector.y(), vector.z());
    }

    public static String getVector3String(Vector3dc vector) {
        return PrintUtils.getVector3String(vector.x(), vector.y(), vector.z());
    }

    public static String getVector3String(Vector3ic vector) {
        return PrintUtils.getVector3String(vector.x(), vector.y(), vector.z());
    }

    public static String getVector3String(double x, double y, double z) {
        return "Vector3[" + x + ", " + y + ", " + z + "]";
    }

    public static String getVector4String(Vector4fc vector) {
        return PrintUtils.getVector4String(vector.x(), vector.y(), vector.z(), vector.w());
    }

    public static String getVector4String(Vector4dc vector) {
        return PrintUtils.getVector4String(vector.x(), vector.y(), vector.z(), vector.w());
    }

    public static String getVector4String(Vector4ic vector) {
        return PrintUtils.getVector4String(vector.x(), vector.y(), vector.z(), vector.w());
    }

    public static String getVector4String(double x, double y, double z, double w) {
        return "Vector4[" + x + ", " + y + ", " + z + ", " + w + "]";
    }

    public static String getQuaternionString(Quaternionfc quaternion) {
        return PrintUtils.getQuaternionString(quaternion.x(), quaternion.y(), quaternion.z(), quaternion.w());
    }

    public static String getQuaternionString(Quaterniondc quaternion) {
        return PrintUtils.getQuaternionString(quaternion.x(), quaternion.y(), quaternion.z(), quaternion.w());
    }

    private static String getQuaternionString(double x, double y, double z, double w) {
        return "Quaternion[" + x + ", " + y + ", " + z + ", " + w + "]";
    }

    public static String getMatrix3String(Matrix3fc matrix) {
        return "Matrix3[\n| Rotation (Euler): " + PrintUtils.getVector3String((Vector3fc)matrix.getEulerAnglesXYZ(new Vector3f())) + "\n| Rotation (Quaternion): " + PrintUtils.getQuaternionString((Quaternionfc)matrix.getNormalizedRotation(new Quaternionf())) + "\n\\ Scale: " + PrintUtils.getVector3String((Vector3fc)matrix.getScale(new Vector3f())) + "\n]";
    }

    public static String getMatrix3String(Matrix3dc matrix) {
        return "Matrix3[\n| Rotation (Euler): " + PrintUtils.getVector3String((Vector3dc)matrix.getEulerAnglesXYZ(new Vector3d())) + "\n| Rotation (Quaternion): " + PrintUtils.getQuaternionString((Quaterniondc)matrix.getNormalizedRotation(new Quaterniond())) + "\n\\ Scale: " + PrintUtils.getVector3String((Vector3dc)matrix.getScale(new Vector3d())) + "\n]";
    }

    public static String getMatrix4String(Matrix4fc matrix) {
        return "Matrix4[\n| Translation: " + PrintUtils.getVector3String((Vector3fc)matrix.getTranslation(new Vector3f())) + "\n| Rotation (Euler): " + PrintUtils.getVector3String((Vector3fc)matrix.getEulerAnglesXYZ(new Vector3f())) + "\n| Rotation (Quaternion): " + PrintUtils.getQuaternionString((Quaternionfc)matrix.getNormalizedRotation(new Quaternionf())) + "\n\\ Scale: " + PrintUtils.getVector3String((Vector3fc)matrix.getScale(new Vector3f())) + "\n]";
    }

    public static String getMatrix4String(Matrix4dc matrix) {
        return "Matrix4[\n| Translation: " + PrintUtils.getVector3String((Vector3dc)matrix.getTranslation(new Vector3d())) + "\n| Rotation (Euler): " + PrintUtils.getVector3String((Vector3dc)matrix.getEulerAnglesXYZ(new Vector3d())) + "\n| Rotation (Quaternion): " + PrintUtils.getQuaternionString((Quaterniondc)matrix.getNormalizedRotation(new Quaterniond())) + "\n\\ Scale: " + PrintUtils.getVector3String((Vector3dc)matrix.getScale(new Vector3d())) + "\n]";
    }
}

