/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PriorityMap<K, V>
implements Map<K, V> {
    private final Map<Integer, Map<K, V>> maps;
    private final Supplier<Map<K, V>> mapSupplier = HashMap::new;

    public PriorityMap() {
        this.maps = new HashMap<Integer, Map<K, V>>();
    }

    @Override
    public int size() {
        return this.maps.values().stream().mapToInt(Map::size).sum();
    }

    @Override
    public boolean isEmpty() {
        return this.maps.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.maps.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.maps.containsValue(value);
    }

    @Override
    public V get(Object key) {
        ArrayList<Integer> priorities = new ArrayList<Integer>(this.maps.keySet());
        priorities.sort(Comparator.reverseOrder());
        Iterator iterator = priorities.iterator();
        if (iterator.hasNext()) {
            Integer priority = (Integer)iterator.next();
            Map<K, V> map = this.maps.get(priority);
            return map.get(key);
        }
        return null;
    }

    public V put(int priority, K key, V value) {
        if (!this.maps.containsKey(priority)) {
            this.maps.put(priority, this.mapSupplier.get());
        }
        Map<K, V> map = this.maps.get(priority);
        return map.put(key, value);
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        return this.put(0, key, value);
    }

    public V remove(int priority, Object key) {
        V value = null;
        if (this.maps.containsKey(priority)) {
            value = this.maps.get(priority).remove(key);
            if (this.maps.get(priority).isEmpty()) {
                this.maps.remove(priority);
            }
        }
        return value;
    }

    @Override
    public V remove(Object key) {
        return this.remove(0, key);
    }

    public void putAll(int priority, @NotNull Map<? extends K, ? extends V> m) {
        if (!this.maps.containsKey(priority)) {
            this.maps.put(priority, this.mapSupplier.get());
        }
        this.maps.get(priority).putAll(m);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        this.putAll(0, m);
    }

    @Override
    public void clear() {
        this.maps.clear();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        HashSet<K> keys = new HashSet<K>();
        ArrayList<Integer> priorities = new ArrayList<Integer>(this.maps.keySet());
        priorities.sort(Comparator.reverseOrder());
        for (Integer priority : priorities) {
            Map<K, V> map = this.maps.get(priority);
            keys.addAll(map.keySet());
        }
        return keys;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>();
        ArrayList<Integer> priorities = new ArrayList<Integer>(this.maps.keySet());
        priorities.sort(Comparator.reverseOrder());
        for (Integer priority : priorities) {
            Map<K, V> map = this.maps.get(priority);
            values.addAll(map.values());
        }
        return values;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        ArrayList<Integer> priorities = new ArrayList<Integer>(this.maps.keySet());
        priorities.sort(Comparator.reverseOrder());
        for (Integer priority : priorities) {
            Map<K, V> map = this.maps.get(priority);
            entries.addAll(map.entrySet());
        }
        return entries;
    }
}

