/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import insane96mcp.insanelib.data.IdTagMatcher;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

@JsonAdapter(value=Serializer.class)
public class IdTagRange {
    public IdTagMatcher id;
    public double min;
    public double max;
    public static final Type LIST_TYPE = new TypeToken<ArrayList<IdTagRange>>(){}.getType();

    public IdTagRange(IdTagMatcher.Type type, String id, double value) {
        this(new IdTagMatcher(type, id), value, value);
    }

    public IdTagRange(IdTagMatcher idTagMatcher, double min, double max) {
        this.id = idTagMatcher;
        this.min = min;
        this.max = max;
    }

    public static IdTagRange newId(String location, double min, double max) {
        return IdTagRange.newId(location, null, min, max);
    }

    public static IdTagRange newId(String location, @Nullable String dimension, double min, double max) {
        return new IdTagRange(new IdTagMatcher(IdTagMatcher.Type.ID, location, dimension), min, max);
    }

    public static IdTagRange newTag(String location, double min, double max) {
        return IdTagRange.newTag(location, null, min, max);
    }

    public static IdTagRange newTag(String location, @Nullable String dimension, double min, double max) {
        return new IdTagRange(new IdTagMatcher(IdTagMatcher.Type.TAG, location, dimension), min, max);
    }

    public double getRandomBetween(RandomSource random) {
        return Mth.m_216263_((RandomSource)random, (double)this.min, (double)this.max);
    }

    public int getRandomIntBetween(RandomSource random) {
        return Mth.m_216271_((RandomSource)random, (int)((int)this.min), (int)((int)this.max));
    }

    public String toString() {
        Object s = this.id.location.toString();
        if (this.id.type == IdTagMatcher.Type.TAG) {
            s = "#" + (String)s;
        }
        if (this.id.dimension != null) {
            s = (String)s + " in " + this.id.dimension;
        }
        s = (String)s + ", " + this.min + "~" + this.max;
        return s;
    }

    public static class Serializer
    implements JsonDeserializer<IdTagRange>,
    JsonSerializer<IdTagRange> {
        public IdTagRange deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            IdTagMatcher idTagMatcher = (IdTagMatcher)context.deserialize(jObject.get("id"), IdTagMatcher.class);
            return new IdTagRange(idTagMatcher, GsonHelper.m_144784_((JsonObject)jObject, (String)"min"), GsonHelper.m_144784_((JsonObject)jObject, (String)"max"));
        }

        public JsonElement serialize(IdTagRange src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("id", context.serialize((Object)src.id));
            jObject.addProperty("min", (Number)src.min);
            jObject.addProperty("max", (Number)src.max);
            return jObject;
        }
    }
}

