/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.enchantments;

import net.combatroll.enchantments.CustomConditionalEnchantment;
import net.combatroll.tinyconfig.models.EnchantmentConfig;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class AmplifierEnchantment
extends Enchantment
implements CustomConditionalEnchantment {
    public Operation operation;
    public EnchantmentConfig properties;
    private CustomConditionalEnchantment.Condition condition;

    public double apply(double value, int level) {
        switch (this.operation) {
            case ADD: {
                return value += (double)((float)level * this.properties.bonus_per_level);
            }
            case MULTIPLY: {
                return value *= (double)(1.0f + (float)level * this.properties.bonus_per_level);
            }
        }
        return 0.0;
    }

    public AmplifierEnchantment(Enchantment.Rarity weight, Operation operation, EnchantmentConfig properties, EnchantmentCategory type, EquipmentSlot[] slotTypes) {
        super(weight, type, slotTypes);
        this.operation = operation;
        this.properties = properties;
    }

    public int m_6586_() {
        if (!this.properties.enabled) {
            return 0;
        }
        return this.properties.max_level;
    }

    public int m_6183_(int level) {
        return this.properties.min_cost + (level - 1) * this.properties.step_cost;
    }

    public int m_6175_(int level) {
        return super.m_6183_(level) + 50;
    }

    public boolean m_6594_() {
        return this.properties.enabled;
    }

    public boolean m_6592_() {
        return this.properties.enabled;
    }

    public boolean m_6081_(ItemStack stack) {
        if (this.condition != null) {
            return this.condition.isAcceptableItem(stack);
        }
        return super.m_6081_(stack);
    }

    @Override
    public void setCondition(CustomConditionalEnchantment.Condition condition) {
        this.condition = condition;
    }

    public AmplifierEnchantment condition(CustomConditionalEnchantment.Condition condition) {
        this.setCondition(condition);
        return this;
    }

    public static enum Operation {
        ADD,
        MULTIPLY;

    }
}

