/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.mixin;

import net.combatroll.CombatRoll;
import net.combatroll.api.EntityAttributes_CombatRoll;
import net.combatroll.client.Keybindings;
import net.combatroll.client.RollEffect;
import net.combatroll.compatibility.BetterCombatHelper;
import net.combatroll.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.combatroll.internals.RollManager;
import net.combatroll.internals.RollingEntity;
import net.combatroll.network.Packets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class}, priority=449)
public abstract class MinecraftClientMixin {
    @Shadow
    private int f_91011_;
    @Shadow
    @Nullable
    public LocalPlayer f_91074_;

    @Inject(method={"doAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void doAttack_HEAD(CallbackInfoReturnable<Boolean> info) {
        RollingEntity rollingPlayer = (RollingEntity)this.f_91074_;
        if (rollingPlayer != null && rollingPlayer.getRollManager().isRolling()) {
            info.setReturnValue((Object)false);
            info.cancel();
        }
    }

    @Inject(method={"handleBlockBreaking"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleBlockBreaking_HEAD(boolean bl, CallbackInfo ci) {
        RollingEntity rollingPlayer = (RollingEntity)this.f_91074_;
        if (rollingPlayer != null && rollingPlayer.getRollManager().isRolling()) {
            ci.cancel();
        }
    }

    @Inject(method={"doItemUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void doItemUse_HEAD(CallbackInfo ci) {
        RollingEntity rollingPlayer = (RollingEntity)this.f_91074_;
        if (rollingPlayer != null && rollingPlayer.getRollManager().isRolling()) {
            ci.cancel();
        }
    }

    @Inject(method={"handleInputEvents"}, at={@At(value="TAIL")})
    private void handleInputEvents_TAIL(CallbackInfo ci) {
        this.tryRolling();
    }

    private void tryRolling() {
        Minecraft client = (Minecraft)this;
        if (this.f_91074_ == null || client.m_91104_() || client.f_91080_ != null) {
            return;
        }
        RollingEntity rollingPlayer = (RollingEntity)this.f_91074_;
        RollManager rollManager = rollingPlayer.getRollManager();
        if (Keybindings.roll.m_90857_()) {
            float defaultSlipperiness;
            Block block;
            float slipperiness;
            double liquidHeight;
            if (!rollManager.isRollAvailable((Player)this.f_91074_)) {
                return;
            }
            if (!CombatRoll.config.allow_rolling_while_airborn && !this.f_91074_.m_20096_()) {
                return;
            }
            if ((float)this.f_91074_.m_36324_().m_38702_() <= CombatRoll.config.food_level_required) {
                return;
            }
            if (this.f_91074_.m_6069_() || this.f_91074_.m_20143_()) {
                return;
            }
            if (this.f_91074_.m_20202_() != null) {
                return;
            }
            if (this.f_91074_.m_6117_() || this.f_91074_.m_21254_()) {
                return;
            }
            if (!CombatRoll.config.allow_rolling_while_weapon_cooldown && (double)this.f_91074_.m_36403_(0.0f) < 0.95) {
                return;
            }
            if (BetterCombatHelper.isDoingUpswing()) {
                BetterCombatHelper.cancelUpswing();
            } else if (client.f_91066_.f_92096_.m_90857_()) {
                return;
            }
            if (this.f_91011_ > 0) {
                return;
            }
            float forward = this.f_91074_.f_108618_.f_108567_;
            float sideways = this.f_91074_.f_108618_.f_108566_;
            Vec3 direction = forward == 0.0f && sideways == 0.0f ? new Vec3(0.0, 0.0, 1.0) : new Vec3((double)sideways, 0.0, (double)forward).m_82541_();
            direction = direction.m_82524_((float)Math.toRadians(-1.0 * (double)this.f_91074_.m_146908_()));
            double distance = 0.475 * (EntityAttributes_CombatRoll.getAttributeValue((Player)this.f_91074_, EntityAttributes_CombatRoll.Type.DISTANCE) + (double)CombatRoll.config.additional_roll_distance);
            direction = direction.m_82490_(distance);
            if (this.f_91074_.m_20069_()) {
                liquidHeight = this.f_91074_.m_204036_(FluidTags.f_13131_);
                liquidHeight = Math.min(liquidHeight, 1.0);
                direction = direction.m_82490_(liquidHeight * 0.5);
            }
            if (this.f_91074_.m_20077_()) {
                liquidHeight = this.f_91074_.m_204036_(FluidTags.f_13132_);
                liquidHeight = Math.min(liquidHeight, 1.0);
                direction = direction.m_82490_(0.3);
            }
            if ((slipperiness = (block = this.f_91074_.m_9236_().m_8055_(this.f_91074_.m_20183_().m_7495_()).m_60734_()).m_49958_()) > (defaultSlipperiness = Blocks.f_50034_.m_49958_())) {
                float multiplier = defaultSlipperiness / slipperiness;
                direction = direction.m_82490_((double)(multiplier * multiplier));
            }
            this.f_91074_.m_5997_(direction.f_82479_, direction.f_82480_, direction.f_82481_);
            rollManager.onRoll(this.f_91074_);
            RollEffect.Visuals rollVisuals = new RollEffect.Visuals("combatroll:roll", RollEffect.Particles.PUFF);
            ClientPlayNetworking.send(Packets.RollPublish.ID, new Packets.RollPublish(this.f_91074_.m_19879_(), rollVisuals, direction).write());
            RollEffect.playVisuals(rollVisuals, (Player)this.f_91074_, direction);
        }
    }
}

