/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element;

import cofh.core.client.gui.GuiColor;
import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementBase;
import cofh.core.util.helpers.RenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public abstract class ElementSlider
extends ElementBase {
    public static final ResourceLocation HOVER = new ResourceLocation("cofh_core:textures/gui/elements/button_hover.png");
    public static final ResourceLocation ENABLED = new ResourceLocation("cofh_core:textures/gui/elements/button_enabled.png");
    public static final ResourceLocation DISABLED = new ResourceLocation("cofh_core:textures/gui/elements/button_disabled.png");
    protected int value;
    protected int valueMin;
    protected int valueMax;
    protected int sliderWidth;
    protected int sliderHeight;
    protected boolean isDragging;
    public int borderColor = new GuiColor(120, 120, 120, 255).getColor();
    public int backgroundColor = new GuiColor(0, 0, 0, 255).getColor();

    protected ElementSlider(IGuiAccess containerScreen, int x, int y, int width, int height, int maxValue) {
        this(containerScreen, x, y, width, height, maxValue, 0);
    }

    protected ElementSlider(IGuiAccess containerScreen, int x, int y, int width, int height, int maxValue, int minValue) {
        super(containerScreen, x, y, width, height);
        this.valueMax = maxValue;
        this.valueMin = minValue;
    }

    public ElementSlider setColor(int backgroundColor, int borderColor) {
        this.borderColor = borderColor;
        this.backgroundColor = backgroundColor;
        return this;
    }

    public ElementSlider setSliderSize(int width, int height) {
        this.sliderWidth = width;
        this.sliderHeight = height;
        return this;
    }

    public ElementSlider setValue(int value) {
        if ((value = Math.max(this.valueMin, Math.min(this.valueMax, value))) != this.value) {
            this.value = value;
            this.onValueChanged(this.value);
        }
        return this;
    }

    public ElementSlider setLimits(int min, int max) {
        this.valueMin = min;
        this.valueMax = max;
        this.setValue(this.value);
        return this;
    }

    @Override
    public void drawBackground(GuiGraphics pGuiGraphics, int mouseX, int mouseY) {
        PoseStack poseStack = pGuiGraphics.m_280168_();
        this.drawColoredModalRect(poseStack, this.posX() - 1, this.posY() - 1, this.posX() + this.width + 1, this.posY() + this.height + 1, this.borderColor);
        this.drawColoredModalRect(poseStack, this.posX(), this.posY(), this.posX() + this.width, this.posY() + this.height, this.backgroundColor);
        RenderHelper.resetShaderColor();
    }

    protected void drawSlider(PoseStack poseStack, int mouseX, int mouseY, int sliderX, int sliderY) {
        int sliderMidX = this.sliderWidth / 2;
        int sliderMidY = this.sliderHeight / 2;
        int sliderEndX = this.sliderWidth - sliderMidX;
        int sliderEndY = this.sliderHeight - sliderMidY;
        if (!this.enabled()) {
            RenderHelper.setShaderTexture0(DISABLED);
        } else if (this.isHovering(mouseX, mouseY)) {
            RenderHelper.setShaderTexture0(HOVER);
        } else {
            RenderHelper.setShaderTexture0(ENABLED);
        }
        RenderHelper.setPosTexShader();
        RenderHelper.resetShaderColor();
        this.drawTexturedModalRect(poseStack, sliderX, sliderY, 0, 0, sliderMidX, sliderMidY);
        this.drawTexturedModalRect(poseStack, sliderX, sliderY + sliderMidY, 0, 256 - sliderEndY, sliderMidX, sliderEndY);
        this.drawTexturedModalRect(poseStack, sliderX + sliderMidX, sliderY, 256 - sliderEndX, 0, sliderEndX, sliderMidY);
        this.drawTexturedModalRect(poseStack, sliderX + sliderMidX, sliderY + sliderMidY, 256 - sliderEndX, 256 - sliderEndY, sliderEndX, sliderEndY);
    }

    @Override
    public void drawForeground(GuiGraphics pGuiGraphics, int mouseX, int mouseY) {
        int sliderX = this.posX() + this.getSliderX();
        int sliderY = this.posY() + this.getSliderY();
        this.drawSlider(pGuiGraphics.m_280168_(), mouseX, mouseY, sliderX, sliderY);
        RenderHelper.resetShaderColor();
    }

    protected boolean isHovering(int x, int y) {
        return this.intersectsWith(x, y);
    }

    public int getSliderX() {
        return 0;
    }

    public int getSliderY() {
        return 0;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.isDragging = mouseButton == 0;
        this.update((int)mouseX, (int)mouseY);
        return true;
    }

    @Override
    public void mouseReleased(double mouseX, double mouseY) {
        if (this.isDragging) {
            this.onStopDragging();
        }
        this.isDragging = false;
    }

    @Override
    public void update(int mouseX, int mouseY) {
        if (this.isDragging) {
            this.dragSlider(mouseX - this.posX(), mouseY - this.posY());
        }
    }

    protected abstract void dragSlider(int var1, int var2);

    @Override
    public boolean mouseWheel(double mouseX, double mouseY, double movement) {
        if (movement > 0.0) {
            this.setValue(this.value - 1);
        } else if (movement < 0.0) {
            this.setValue(this.value + 1);
        }
        return true;
    }

    public void onValueChanged(int value) {
    }

    public void onStopDragging() {
    }

    public int getValue() {
        return this.value;
    }
}

