/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common.entity;

import cofh.core.client.particle.options.BiColorParticleOptions;
import cofh.core.common.TransientLightManager;
import cofh.core.common.config.CoreClientConfig;
import cofh.core.init.CoreEntities;
import cofh.core.init.CoreMobEffects;
import cofh.core.init.CoreParticles;
import cofh.core.util.AreaUtils;
import cofh.core.util.helpers.ArcheryHelper;
import cofh.lib.common.entity.AbstractFieldSpell;
import cofh.lib.util.Utils;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ElectricField
extends AbstractFieldSpell {
    protected int lastArc = 0;

    public ElectricField(EntityType<? extends ElectricField> type, Level level) {
        super((EntityType<? extends AbstractFieldSpell>)type, level);
    }

    public ElectricField(EntityType<? extends ElectricField> type, Level level, Vec3 pos, Entity owner, float power, int duration, float radius) {
        super(type, level, pos, owner, power, duration, radius);
    }

    public ElectricField(Level level, Vec3 pos, Entity owner, float power, int duration, float radius) {
        this((EntityType<? extends ElectricField>)((EntityType)CoreEntities.ELECTRIC_FIELD.get()), level, pos, owner, power, duration, radius);
    }

    @Override
    public EntityDimensions m_6972_(Pose pose) {
        return this.m_6095_().m_20680_().m_20388_(this.radius * 2.0f);
    }

    @Override
    public void activeTick() {
        if (!this.f_19853_.m_5776_()) {
            int max = 16;
            if (this.f_19797_ < this.duration + 10 && (this.lastArc >= max || this.f_19796_.m_188503_(max - this.lastArc) == 0)) {
                this.lastArc = 0;
                this.summonArc();
            } else {
                ++this.lastArc;
            }
        } else if (CoreClientConfig.particleDynamicLighting.get().booleanValue()) {
            TransientLightManager.addLight(BlockPos.m_274446_((Position)this.m_146892_()), 8);
        }
    }

    protected void summonArc() {
        Vec3 center = this.m_20182_();
        Predicate<Entity> filter = EntitySelector.f_20403_;
        Entity owner = this.m_19749_();
        if (owner != null) {
            filter = filter.and(entity -> !entity.m_20365_(owner));
        }
        float radius = this.getRadius();
        List<Entity> entities = AreaUtils.getEntitiesInSphere(this.f_19853_, center, radius, this, filter);
        Vec3 end = this.rand.nextInt(5) < entities.size() ? entities.get(this.rand.nextInt(entities.size())).m_20191_().m_82399_() : new Vec3(this.rand.nextGaussian(), -Math.abs(this.rand.nextGaussian()), this.rand.nextGaussian()).m_82541_().m_82490_((double)radius).m_82549_(center);
        Vec3 pos = this.m_146892_();
        BlockHitResult raytrace = this.f_19853_.m_45547_(new ClipContext(pos, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        end = raytrace.m_82450_();
        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BiColorParticleOptions((ParticleType<? extends BiColorParticleOptions>)((ParticleType)CoreParticles.STRAIGHT_ARC.get()), 0.2f, 4.0f, 0.0f, -1, -240988), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, end.f_82479_, end.f_82480_, end.f_82481_, 1.0);
        float padding = 0.1f;
        DamageSource source = Utils.source(this.m_269291_(), this.getDamageType(), this, owner == null ? this : owner, pos);
        ArcheryHelper.findHitEntities(entities.stream(), pos, end, new Vec3((double)padding, (double)padding, (double)padding)).forEach(result -> {
            Entity target = result.m_82443_();
            target.m_6469_(source, this.power * 4.0f);
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                if (this.rand.nextFloat() < this.power * 0.4f) {
                    living.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.SHOCKED.get(), 80, 0, true, false, true));
                }
            }
        });
    }

    public int getTextureIndex(int max) {
        if (this.f_19797_ < 3 || this.duration - this.f_19797_ < 3) {
            return 0;
        }
        return this.f_19796_.m_188503_(max - 1) + 1;
    }

    protected ResourceKey<DamageType> getDamageType() {
        return DamageTypes.f_268450_;
    }
}

