/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.api.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.flemmli97.tenshilib.api.config.SimpleItemStackWrapper;
import io.github.flemmli97.tenshilib.common.utils.JsonUtils;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import java.lang.reflect.Type;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ExtendedItemStackWrapper
extends SimpleItemStackWrapper {
    protected CompoundTag nbtTagCompound;

    public ExtendedItemStackWrapper(CompoundTag compound) {
        this(compound.m_128461_("id"), compound.m_128451_("Count"), compound.m_128469_("nbt"));
    }

    public ExtendedItemStackWrapper(String item) {
        this(item, 1);
    }

    public ExtendedItemStackWrapper(String item, int count) {
        this(item, count, null);
    }

    public ExtendedItemStackWrapper(String item, int count, CompoundTag nbt) {
        super(item, count);
    }

    public ExtendedItemStackWrapper setNBT(CompoundTag nbt) {
        this.nbtTagCompound = nbt;
        return this;
    }

    public ExtendedItemStackWrapper ignoreNBT() {
        this.nbtTagCompound = null;
        return this;
    }

    @Override
    public boolean match(ItemStack stack) {
        return super.match(stack) && (this.nbtTagCompound == null && stack.m_41783_() == null || this.nbtTagCompound != null && this.nbtTagCompound.equals((Object)stack.m_41783_()));
    }

    @Override
    public ExtendedItemStackWrapper readFromString(String s) {
        try {
            CompoundTag nbt = TagParser.m_129359_((String)s);
            this.nbtTagCompound = nbt.m_128469_("nbt");
            this.count = nbt.m_128451_("Count");
            this.reg = nbt.m_128461_("id");
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public String writeToString() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("nbt", (Tag)this.nbtTagCompound.m_6426_());
        nbt.m_128359_("id", PlatformUtils.INSTANCE.items().getIDFrom(this.item).toString());
        nbt.m_128405_("Count", this.count);
        return nbt.toString();
    }

    public static String usage() {
        return "Complete ItemStack nbt (meaning with id and count)";
    }

    @Nullable
    public CompoundTag getTag() {
        return this.nbtTagCompound == null ? null : this.nbtTagCompound.m_6426_();
    }

    @Override
    public ItemStack getStack() {
        ItemStack stack = super.getStack();
        if (!stack.m_41619_() && this.nbtTagCompound != null) {
            stack.m_41751_(this.nbtTagCompound.m_6426_());
        }
        return stack;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExtendedItemStackWrapper) {
            ExtendedItemStackWrapper prop = (ExtendedItemStackWrapper)obj;
            return prop.toString().equals(this.toString());
        }
        return false;
    }

    public static class Serializer
    implements JsonDeserializer<ExtendedItemStackWrapper>,
    JsonSerializer<ExtendedItemStackWrapper> {
        public JsonElement serialize(ExtendedItemStackWrapper src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.add("item", (JsonElement)new JsonPrimitive(src.reg));
            if (src.count != 1) {
                obj.add("count", (JsonElement)new JsonPrimitive((Number)src.count));
            }
            if (src.nbtTagCompound != null) {
                obj.add("nbt", (JsonElement)new JsonPrimitive(src.nbtTagCompound.toString()));
            }
            return obj;
        }

        public ExtendedItemStackWrapper deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int count = JsonUtils.get(obj, "count", 1);
            JsonObject nbt = obj.has("nbt") ? obj.get("nbt").getAsJsonObject() : null;
            CompoundTag compound = null;
            if (nbt != null) {
                try {
                    compound = TagParser.m_129359_((String)nbt.toString());
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            }
            return new ExtendedItemStackWrapper(obj.get("item").getAsString(), count, compound);
        }
    }
}

