/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client;

import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import io.github.flemmli97.tenshilib.api.entity.IOverlayEntityRender;
import io.github.flemmli97.tenshilib.api.item.IAOEWeapon;
import io.github.flemmli97.tenshilib.api.item.IExtendedWeapon;
import io.github.flemmli97.tenshilib.client.CustomRiderRendererManager;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.HitResult;

public class ClientHandlers {
    public static final Set<UUID> RIDING_RENDER_BLACKLIST = new HashSet<UUID>();

    public static void updateAnim(int entityID, int animID) {
        Minecraft mc = Minecraft.m_91087_();
        Entity e = mc.f_91073_.m_6815_(entityID);
        if (e instanceof IAnimated) {
            IAnimated anim = (IAnimated)e;
            anim.getAnimationHandler().setAnimation(animID == -2 ? null : (animID == -1 ? AnimatedAction.vanillaAttack : anim.getAnimationHandler().getAnimations()[animID]));
        }
    }

    public static int getColor(LivingEntity entity, float f) {
        IOverlayEntityRender overlay = (IOverlayEntityRender)entity;
        int oV = (int)(f * 15.0f);
        int oU = entity.f_20916_ > 0 || entity.f_20919_ > 0 ? 3 : 10;
        return OverlayTexture.m_118093_((int)overlay.overlayU(oV), (int)overlay.overlayV(oU));
    }

    public static Player clientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static boolean shouldDisableRender(Entity entity) {
        Entity entity2 = entity.m_20202_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity2;
            if (CustomRiderRendererManager.getInstance().hasRiderLayerRenderer(vehicle.m_6095_())) {
                if (RIDING_RENDER_BLACKLIST.contains(entity.m_20148_())) {
                    return false;
                }
                return entity != Minecraft.m_91087_().f_91074_ || !Minecraft.m_91087_().f_91066_.m_92176_().m_90612_();
            }
        }
        return false;
    }

    public static boolean emptyClick(Consumer<Boolean> packetHandler) {
        IAOEWeapon aoe;
        Item item;
        Minecraft client = Minecraft.m_91087_();
        ItemStack main = client.f_91074_.m_21205_();
        if (client.f_91077_ != null && (client.f_91077_.m_6662_() != HitResult.Type.BLOCK || (item = main.m_41720_()) instanceof IAOEWeapon && !(aoe = (IAOEWeapon)item).allowBlockAttack((LivingEntity)client.f_91074_, main))) {
            Item item2 = main.m_41720_();
            if (item2 instanceof IExtendedWeapon) {
                IExtendedWeapon weapon = (IExtendedWeapon)item2;
                packetHandler.accept(false);
                if (weapon.resetAttackStrength((LivingEntity)client.f_91074_, main)) {
                    client.f_91074_.m_36334_();
                }
                if (weapon.swingWeapon((LivingEntity)client.f_91074_, main)) {
                    client.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
                }
                return true;
            }
            item2 = main.m_41720_();
            if (item2 instanceof IAOEWeapon) {
                IAOEWeapon weapon = (IAOEWeapon)item2;
                packetHandler.accept(true);
                if (weapon.resetAttackStrength((LivingEntity)client.f_91074_, main)) {
                    client.f_91074_.m_36334_();
                }
                if (weapon.swingWeapon((LivingEntity)client.f_91074_, main)) {
                    client.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
                }
                return true;
            }
        }
        return false;
    }
}

