/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.addon.toughasnails;

import com.mojang.blaze3d.shaders.Uniform;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.premade.IntMinMax;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.api.type.VisualTypeShader;
import team.creative.enhancedvisuals.client.VisualManager;
import team.creative.enhancedvisuals.mixin.PostChainAccessor;
import toughasnails.api.thirst.ThirstHelper;

public class ThirstHandler
extends VisualHandler {
    @CreativeConfig
    public double defaultIntensity = 0.0;
    @CreativeConfig
    public double maxIntensity = 5.0;
    @CreativeConfig
    public double fadeFactor = 0.05f;
    @CreativeConfig
    public IntMinMax thirstLevel = new IntMinMax(2, 8);
    @CreativeConfig
    public VisualType focus = new VisualTypeShader("focus", new ResourceLocation("shaders/post/blobs2.json")){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void changeProperties(float intensity) {
            for (PostPass pass : ((PostChainAccessor)this.postChain).getPasses()) {
                Uniform shaderuniform = pass.m_110074_().m_108952_("Radius");
                if (shaderuniform == null) continue;
                shaderuniform.m_5985_(intensity);
            }
        }
    };
    public Visual focusVisual;

    @Override
    public void tick(@Nullable Player player) {
        if (this.focusVisual == null) {
            this.focusVisual = new Visual(this.focus, this, 0);
            VisualManager.add(this.focusVisual);
        }
        double aimedSaturation = this.defaultIntensity;
        if (player != null && player.m_6084_() && ThirstHelper.isThirstEnabled()) {
            int thirst = ThirstHelper.getThirst((Player)player).getThirst();
            if (thirst <= this.thirstLevel.max) {
                double leftFoodInSpan = thirst - this.thirstLevel.min;
                double spanLength = this.thirstLevel.spanLength();
                aimedSaturation = (1.0 - leftFoodInSpan / spanLength) * this.maxIntensity;
            }
            if ((double)this.focusVisual.getOpacityInternal() < aimedSaturation) {
                this.focusVisual.setOpacityInternal((float)Math.min((double)this.focusVisual.getOpacityInternal() + this.fadeFactor, aimedSaturation));
            } else if ((double)this.focusVisual.getOpacityInternal() > aimedSaturation) {
                this.focusVisual.setOpacityInternal((float)Math.max((double)this.focusVisual.getOpacityInternal() - this.fadeFactor, aimedSaturation));
            }
        } else {
            this.focusVisual.setOpacityInternal((float)this.defaultIntensity);
        }
    }
}

