/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.event;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.enhancedvisuals.EnhancedVisuals;
import team.creative.enhancedvisuals.client.EVClient;
import team.creative.enhancedvisuals.client.VisualManager;
import team.creative.enhancedvisuals.client.sound.SoundMuteHandler;
import team.creative.enhancedvisuals.common.packet.DamagePacket;
import team.creative.enhancedvisuals.common.packet.ExplosionPacket;
import team.creative.enhancedvisuals.common.packet.PotionPacket;
import team.creative.enhancedvisuals.mixin.EntityAccessor;
import team.creative.enhancedvisuals.mixin.ExplosionAccessor;

public class EVEvents {
    public void explosion(Explosion explosion, List<Entity> affected) {
        Vec3 position = new Vec3(((ExplosionAccessor)explosion).getX(), ((ExplosionAccessor)explosion).getY(), ((ExplosionAccessor)explosion).getZ());
        ExplosionPacket packet = new ExplosionPacket(position, ((ExplosionAccessor)explosion).getRadius(), ((ExplosionAccessor)explosion).getSource() != null ? ((ExplosionAccessor)explosion).getSource().m_19879_() : -1);
        for (Entity entity : affected) {
            if (!(entity instanceof ServerPlayer)) continue;
            EnhancedVisuals.NETWORK.sendToClient((CreativePacket)packet, (ServerPlayer)entity);
        }
    }

    public void impact(Projectile projectile) {
        if (projectile instanceof ThrownPotion) {
            ThrownPotion entity = (ThrownPotion)projectile;
            if (!projectile.m_9236_().f_46443_) {
                AABB axisalignedbb = entity.m_20191_().m_82377_(4.0, 2.0, 4.0);
                List list = entity.m_9236_().m_45976_(LivingEntity.class, axisalignedbb);
                if (!list.isEmpty()) {
                    for (LivingEntity livingentity : list) {
                        double d0;
                        if (!livingentity.m_5801_() || !(livingentity instanceof ServerPlayer) || !((d0 = entity.m_20280_((Entity)livingentity)) < 16.0)) continue;
                        EnhancedVisuals.NETWORK.sendToClient((CreativePacket)new PotionPacket(Math.sqrt(d0), entity.m_7846_()), (ServerPlayer)livingentity);
                    }
                }
            }
        }
    }

    public void damage(Player target, DamageSource source, float damage) {
        if (target.m_9236_().f_46443_) {
            return;
        }
        if (EnhancedVisuals.CONFIG.enableDamageDebug) {
            target.m_213846_((Component)Component.m_237113_((String)(source.m_19385_() + "," + source.m_6157_((LivingEntity)target).getString())));
        }
        EnhancedVisuals.NETWORK.sendToClient((CreativePacket)new DamagePacket(target, source, damage), (ServerPlayer)target);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void respawn() {
        VisualManager.clearEverything();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        if (EVClient.shouldTick()) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            VisualManager.onTick((Player)player);
        }
        SoundMuteHandler.tick();
    }

    public static boolean areEyesInWater(Player player) {
        return ((EntityAccessor)player).getWasEyeInWater();
    }
}

