/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.packet;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.network.CanBeNull;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.enhancedvisuals.common.handler.VisualHandlers;

public class DamagePacket
extends CreativePacket {
    @CanBeNull
    public String attackerClass;
    @CanBeNull
    public ItemStack stack;
    public float damage;
    public float distance;
    public boolean fire;
    public String source;

    public DamagePacket(Player target, DamageSource source, float damage) {
        this.damage = damage;
        Entity attacker = source.m_7640_();
        this.fire = source.m_269533_(DamageTypeTags.f_268745_);
        if (attacker instanceof LivingEntity || attacker instanceof Arrow) {
            this.attackerClass = attacker.getClass().getName().toLowerCase();
            this.source = "attacker";
            if (attacker instanceof LivingEntity && ((LivingEntity)attacker).m_21205_() != null) {
                this.stack = ((LivingEntity)attacker).m_21205_();
            }
        } else {
            this.source = source.m_19385_();
        }
    }

    public DamagePacket() {
    }

    public void executeClient(Player player) {
        if (VisualHandlers.DAMAGE.isEnabled(player)) {
            VisualHandlers.DAMAGE.playerDamaged(player, this);
        }
    }

    public void executeServer(ServerPlayer player) {
    }
}

