/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.block_entities;

import andrews.table_top_craft.registry.TTCBlockEntities;
import andrews.table_top_craft.util.NBTColorSaving;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class ChessPieceFigureBlockEntity
extends BlockEntity {
    private final Random rand = new Random();
    private int pieceType;
    private boolean rotateChessPieceFigure;
    private String pieceColor;
    private int pieceSet;
    private double pieceScale;
    private String name;

    public ChessPieceFigureBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TTCBlockEntities.CHESS_PIECE_FIGURE.get(), pos, state);
    }

    public AABB getRenderBoundingBox() {
        double scale = this.getPieceScale();
        double verticalScale = 0.14 * scale;
        return super.getRenderBoundingBox().m_82363_(-verticalScale, 0.6 * scale, -verticalScale).m_82386_(verticalScale / 2.0, 0.0, verticalScale / 2.0);
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = new CompoundTag();
        this.saveToNBT(compound);
        return compound;
    }

    public void handleUpdateTag(CompoundTag compound) {
        this.loadFromNBT(compound);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.loadFromNBT(pkt.m_131708_());
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.saveToNBT(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.loadFromNBT(compound);
    }

    private void saveToNBT(CompoundTag compound) {
        compound.m_128405_("PieceType", this.getPieceType());
        compound.m_128405_("RotateChessPieceFigure", !this.rotateChessPieceFigure ? 0 : 1);
        compound.m_128359_("PieceColor", this.getPieceColor());
        compound.m_128405_("PieceSet", this.getPieceSet());
        compound.m_128347_("PieceScale", this.getPieceScale());
        if (this.getPieceName() != null) {
            compound.m_128359_("PieceName", this.getPieceName());
        }
    }

    private void loadFromNBT(CompoundTag compound) {
        this.pieceType = compound.m_128451_("PieceType");
        if (compound.m_128425_("RotateChessPieceFigure", 3)) {
            boolean bl = this.rotateChessPieceFigure = compound.m_128451_("RotateChessPieceFigure") != 0;
        }
        if (compound.m_128425_("PieceColor", 8)) {
            this.pieceColor = compound.m_128461_("PieceColor");
        }
        if (compound.m_128425_("PieceSet", 3)) {
            this.pieceSet = compound.m_128451_("PieceSet");
        }
        if (compound.m_128425_("PieceScale", 6)) {
            this.pieceScale = compound.m_128459_("PieceScale");
        }
        if (compound.m_128425_("PieceName", 8)) {
            this.name = compound.m_128461_("PieceName");
        }
    }

    public int getPieceType() {
        if (this.pieceType == 0 && !this.f_58857_.f_46443_) {
            this.setPieceType(this.rand.nextInt(6) + 1);
        }
        return this.pieceType;
    }

    public void setPieceType(int type) {
        this.pieceType = type;
        this.m_6596_();
    }

    public int getPieceSet() {
        if (this.pieceSet == 0 && !this.f_58857_.f_46443_) {
            this.setPieceSet(this.rand.nextInt(3) + 1);
        }
        return this.pieceSet;
    }

    public void setPieceSet(int pieceSet) {
        this.pieceSet = pieceSet;
        this.m_6596_();
    }

    public void setRotateChessPieceFigure(boolean rotateChessPieceFigure) {
        this.rotateChessPieceFigure = rotateChessPieceFigure;
        this.m_6596_();
    }

    public boolean getRotateChessPieceFigure() {
        return this.rotateChessPieceFigure;
    }

    public void setPieceColor(String colorForNBT) {
        this.pieceColor = colorForNBT;
    }

    public String getPieceColor() {
        return this.pieceColor == null ? NBTColorSaving.createWhitePiecesColor() : this.pieceColor;
    }

    public void setPieceScale(double pieceScale) {
        this.pieceScale = pieceScale;
    }

    public double getPieceScale() {
        return this.pieceScale == 0.0 ? 1.0 : this.pieceScale;
    }

    public void setPieceName(String pieceName) {
        this.name = pieceName;
    }

    public String getPieceName() {
        return this.name;
    }
}

