/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.block_entities.render;

import andrews.table_top_craft.block_entities.ChessPieceFigureBlockEntity;
import andrews.table_top_craft.block_entities.model.piece_figure.ChessPieceFigureStandModel;
import andrews.table_top_craft.block_entities.render.BufferHelpers;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.objects.blocks.ChessPieceFigureBlock;
import andrews.table_top_craft.util.Color;
import andrews.table_top_craft.util.DrawScreenHelper;
import andrews.table_top_craft.util.NBTColorSaving;
import andrews.table_top_craft.util.TTCRenderTypes;
import andrews.table_top_craft.util.shader_compat.ShaderCompatHandler;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ChessPieceFigureTileEntityRenderer
implements BlockEntityRenderer<ChessPieceFigureBlockEntity> {
    private static final NativeImage image = new NativeImage(NativeImage.Format.RGBA, 1, 1, true);
    private static final DynamicTexture texture = new DynamicTexture(image);
    private static final ResourceLocation resourceLocation;
    public static final ResourceLocation SHADER_COMPAT_WHITE;
    public static final ResourceLocation CHESS_PIECE_FIGURE_TEXTURE;
    private static ChessPieceFigureStandModel chessPieceFigureStandModel;
    private Color color = new Color(0, 0, 0);

    public ChessPieceFigureTileEntityRenderer(BlockEntityRendererProvider.Context context) {
        chessPieceFigureStandModel = new ChessPieceFigureStandModel(context.m_173582_(ChessPieceFigureStandModel.CHESS_PIECE_FIGURE_LAYER));
    }

    public void render(ChessPieceFigureBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity.getPieceName() != null && blockEntity.getPieceName().equals("andrew_")) {
            int tickCount = Minecraft.m_91087_().f_91074_.f_19797_;
            int value = tickCount % 180 * 2;
            this.color = this.color.fromHSV(value, 1.0f, 1.0f);
            blockEntity.setPieceColor(this.color.getRed() + "/" + this.color.getGreen() + "/" + this.color.getBlue() + "/255");
        }
        ChessPieceFigureTileEntityRenderer.renderChessPieceFigure(blockEntity, poseStack, bufferSource, false, false, partialTicks, packedLight, packedOverlay);
    }

    public static void renderChessPieceFigure(ChessPieceFigureBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, boolean isInGui, boolean isHeldOrHead, float partialTicks, int packedLight, int packedOverlay) {
        BlockState blockstate;
        Matrix4f initialMatrix = poseStack.m_85850_().m_252922_();
        if (!blockEntity.m_58898_()) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 1.5, 0.5);
            poseStack.m_85841_(1.0f, -1.0f, -1.0f);
            if (blockEntity.getRotateChessPieceFigure() && isInGui) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks));
            }
            VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)CHESS_PIECE_FIGURE_TEXTURE));
            chessPieceFigureStandModel.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
        int rotation = 0;
        if (blockEntity.m_58898_() && (blockstate = blockEntity.m_58904_().m_8055_(blockEntity.m_58899_())).m_60734_() instanceof ChessPieceFigureBlock) {
            rotation = (Integer)blockstate.m_61143_((Property)ChessPieceFigureBlock.ROTATION);
        }
        int lightU = LightTexture.m_109883_((int)packedLight);
        int lightV = LightTexture.m_109894_((int)packedLight);
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.125f, 0.5f);
        poseStack.m_252781_(Axis.f_252392_.m_252977_((float)rotation * 22.5f));
        if (blockEntity.getRotateChessPieceFigure()) {
            poseStack.m_252781_(Axis.f_252392_.m_252977_((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks));
        }
        poseStack.m_85841_(3.0f, -3.0f, -3.0f);
        if (blockEntity.getPieceName() != null && blockEntity.getPieceName().equals("Lyzantra")) {
            poseStack.m_85837_(0.0, -0.2 * blockEntity.getPieceScale(), 0.0);
            poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
        }
        if (blockEntity.m_58898_()) {
            float scale = (float)blockEntity.getPieceScale();
            poseStack.m_85841_(scale, scale, scale);
        }
        float red = (float)NBTColorSaving.getRed(blockEntity.getPieceColor()) / 255.0f;
        float green = (float)NBTColorSaving.getGreen(blockEntity.getPieceColor()) / 255.0f;
        float blue = (float)NBTColorSaving.getBlue(blockEntity.getPieceColor()) / 255.0f;
        BasePiece.PieceModelSet set = BasePiece.PieceModelSet.get(blockEntity.getPieceSet());
        BasePiece.PieceType piece = BasePiece.PieceType.get(blockEntity.getPieceType());
        if (ShaderCompatHandler.isShaderActive()) {
            poseStack.m_85836_();
            VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)SHADER_COMPAT_WHITE));
            if (isInGui || isHeldOrHead) {
                poseStack.m_85841_(isHeldOrHead ? 1.3f : 1.4f, isHeldOrHead ? 1.3f : 1.4f, isHeldOrHead ? 1.3f : 1.4f);
                if (blockEntity.getPieceName() != null && blockEntity.getPieceName().equals("Lyzantra")) {
                    poseStack.m_85837_(0.0, 0.05, 0.0);
                }
            }
            DrawScreenHelper.CHESS_PIECE_MODEL.render(poseStack, consumer, piece, set, red, green, blue, packedLight);
            poseStack.m_85849_();
        } else {
            poseStack.m_85836_();
            RenderType type = TTCRenderTypes.getChessPieceSolid(resourceLocation);
            type.m_110185_();
            ShaderInstance shaderinstance = RenderSystem.getShader();
            if (shaderinstance.f_173309_ != null) {
                shaderinstance.f_173309_.m_5679_(RenderSystem.getProjectionMatrix());
            }
            BufferHelpers.setupRender(RenderSystem.getShader(), lightU, lightV);
            BufferHelpers.updateColor(shaderinstance, new float[]{red, green, blue, 1.0f});
            poseStack.m_85836_();
            if (shaderinstance.f_173308_ != null) {
                if (isInGui || isHeldOrHead) {
                    Matrix4f mat4f = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
                    PoseStack stk = new PoseStack();
                    stk.m_85850_().m_252922_().mul((Matrix4fc)mat4f);
                    stk.m_85850_().m_252922_().mul((Matrix4fc)initialMatrix);
                    stk.m_252880_(0.5f, 0.125f, 0.5f);
                    if (blockEntity.getRotateChessPieceFigure()) {
                        stk.m_252781_(Axis.f_252392_.m_252977_((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks));
                    }
                    if (blockEntity.getPieceName() != null && blockEntity.getPieceName().equals("Lyzantra")) {
                        stk.m_85837_(0.0, 0.85, 0.0);
                        stk.m_252781_(Axis.f_252393_.m_252977_(180.0f));
                    }
                    stk.m_85841_(isHeldOrHead ? 3.0f : 4.0f, isHeldOrHead ? -3.0f : -4.0f, isHeldOrHead ? -3.0f : -4.0f);
                    shaderinstance.f_173308_.m_5679_(stk.m_85850_().m_252922_());
                } else {
                    shaderinstance.f_173308_.m_5679_(poseStack.m_85850_().m_252922_());
                }
            }
            VertexBuffer pawnBuffer = DrawScreenHelper.getBuffer(set, piece);
            TTCRenderTypes.getChessPieceSolid(resourceLocation).m_110185_();
            BufferHelpers.draw(pawnBuffer);
            VertexBuffer.m_85931_();
            shaderinstance.m_173362_();
            type.m_110188_();
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    static {
        SHADER_COMPAT_WHITE = new ResourceLocation("table_top_craft", "textures/tile/compat/full_white.png");
        CHESS_PIECE_FIGURE_TEXTURE = new ResourceLocation("table_top_craft", "textures/tile/chess_piece_figure/chess_piece_figure.png");
        image.m_84988_(0, 0, 0xFFFFFF);
        texture.m_117985_();
        resourceLocation = Minecraft.m_91087_().m_91097_().m_118490_("table_top_craft_dummy", texture);
    }
}

