/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess.pgn;

import andrews.table_top_craft.game_logic.chess.PieceColor;
import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.BoardUtils;
import andrews.table_top_craft.game_logic.chess.pieces.BishopPiece;
import andrews.table_top_craft.game_logic.chess.pieces.KingPiece;
import andrews.table_top_craft.game_logic.chess.pieces.KnightPiece;
import andrews.table_top_craft.game_logic.chess.pieces.PawnPiece;
import andrews.table_top_craft.game_logic.chess.pieces.QueenPiece;
import andrews.table_top_craft.game_logic.chess.pieces.RookPiece;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class FenUtil {
    private FenUtil() {
    }

    public static Board createGameFromFEN(String fenString, String firstMovesList, boolean isWhiteCastled, boolean isBlackCastled) {
        return FenUtil.parseFEN(fenString, firstMovesList, isWhiteCastled, isBlackCastled);
    }

    public static Board createGameFromFEN(String fenString) {
        return FenUtil.parseFEN(fenString);
    }

    public static String createFENFromGame(Board board) {
        return FenUtil.calculateBoardText(board) + " " + FenUtil.calculateCurrentPlayerText(board) + " " + FenUtil.calculateCastleText(board) + " " + FenUtil.calculateEnPassantSquare(board) + " 0 0";
    }

    private static Board parseFEN(String fenString, String firstMovesList, boolean isWhiteCastled, boolean isBlackCastled) {
        String[] fenPartitions = fenString.trim().split(" ");
        String[] firstMoveTiles = firstMovesList.trim().split("/");
        Board.Builder builder = new Board.Builder();
        boolean whiteKingSideCastle = FenUtil.whiteKingSideCastle(fenPartitions[2]);
        boolean whiteQueenSideCastle = FenUtil.whiteQueenSideCastle(fenPartitions[2]);
        boolean blackKingSideCastle = FenUtil.blackKingSideCastle(fenPartitions[2]);
        boolean blackQueenSideCastle = FenUtil.blackQueenSideCastle(fenPartitions[2]);
        String gameConfiguration = fenPartitions[0];
        char[] boardTiles = gameConfiguration.replaceAll("/", "").replaceAll("8", "--------").replaceAll("7", "-------").replaceAll("6", "------").replaceAll("5", "-----").replaceAll("4", "----").replaceAll("3", "---").replaceAll("2", "--").replaceAll("1", "-").toCharArray();
        int i = 0;
        int enPassantCoordinate = -1;
        if (Arrays.stream(BoardUtils.ALGEBRAIC_NOTATION).anyMatch(fenPartitions[3]::equals)) {
            enPassantCoordinate = BoardUtils.getCoordinateAtPosition(fenPartitions[3]);
        }
        block15: while (i < boardTiles.length) {
            PawnPiece enPassantPawn;
            if (enPassantCoordinate != -1 && enPassantCoordinate == i - 8 && BoardUtils.SIXTH_RANK[enPassantCoordinate]) {
                enPassantPawn = new PawnPiece(PieceColor.BLACK, i);
                builder.setPiece(enPassantPawn);
                builder.setEnPassantPawn(enPassantPawn);
                ++i;
                continue;
            }
            if (enPassantCoordinate != -1 && enPassantCoordinate == i + 8 && BoardUtils.THIRD_RANK[enPassantCoordinate]) {
                enPassantPawn = new PawnPiece(PieceColor.WHITE, i);
                builder.setPiece(enPassantPawn);
                builder.setEnPassantPawn(enPassantPawn);
                ++i;
                continue;
            }
            switch (boardTiles[i]) {
                case 'r': {
                    builder.setPiece(new RookPiece(PieceColor.BLACK, i, FenUtil.checkIsFirstMove(i, firstMoveTiles)));
                    ++i;
                    continue block15;
                }
                case 'n': {
                    builder.setPiece(new KnightPiece(PieceColor.BLACK, i, FenUtil.checkIsFirstMove(i, firstMoveTiles)));
                    ++i;
                    continue block15;
                }
                case 'b': {
                    builder.setPiece(new BishopPiece(PieceColor.BLACK, i, FenUtil.checkIsFirstMove(i, firstMoveTiles)));
                    ++i;
                    continue block15;
                }
                case 'q': {
                    builder.setPiece(new QueenPiece(PieceColor.BLACK, i, FenUtil.checkIsFirstMove(i, firstMoveTiles)));
                    ++i;
                    continue block15;
                }
                case 'k': {
                    builder.setPiece(new KingPiece(PieceColor.BLACK, i, FenUtil.checkIsFirstMove(i, firstMoveTiles), isBlackCastled, blackKingSideCastle, blackQueenSideCastle));
                    ++i;
                    continue block15;
                }
                case 'p': {
                    builder.setPiece(new PawnPiece(PieceColor.BLACK, i, FenUtil.checkIsFirstMove(i, firstMoveTiles)));
                    ++i;
                    continue block15;
                }
                case 'R': {
                    builder.setPiece(new RookPiece(PieceColor.WHITE, i, FenUtil.checkIsFirstMove(i, firstMoveTiles)));
                    ++i;
                    continue block15;
                }
                case 'N': {
                    builder.setPiece(new KnightPiece(PieceColor.WHITE, i, FenUtil.checkIsFirstMove(i, firstMoveTiles)));
                    ++i;
                    continue block15;
                }
                case 'B': {
                    builder.setPiece(new BishopPiece(PieceColor.WHITE, i, FenUtil.checkIsFirstMove(i, firstMoveTiles)));
                    ++i;
                    continue block15;
                }
                case 'Q': {
                    builder.setPiece(new QueenPiece(PieceColor.WHITE, i, FenUtil.checkIsFirstMove(i, firstMoveTiles)));
                    ++i;
                    continue block15;
                }
                case 'K': {
                    builder.setPiece(new KingPiece(PieceColor.WHITE, i, FenUtil.checkIsFirstMove(i, firstMoveTiles), isWhiteCastled, whiteKingSideCastle, whiteQueenSideCastle));
                    ++i;
                    continue block15;
                }
                case 'P': {
                    builder.setPiece(new PawnPiece(PieceColor.WHITE, i, FenUtil.checkIsFirstMove(i, firstMoveTiles)));
                    ++i;
                    continue block15;
                }
                case '-': {
                    ++i;
                    continue block15;
                }
            }
            throw new RuntimeException("Invalid FEN String " + gameConfiguration);
        }
        builder.setMoveMaker(FenUtil.moveMaker(fenPartitions[1]));
        return builder.build();
    }

    private static Board parseFEN(String fenString) {
        String[] fenPartitions = fenString.trim().split(" ");
        Board.Builder builder = new Board.Builder();
        boolean whiteKingSideCastle = FenUtil.whiteKingSideCastle(fenPartitions[2]);
        boolean whiteQueenSideCastle = FenUtil.whiteQueenSideCastle(fenPartitions[2]);
        boolean blackKingSideCastle = FenUtil.blackKingSideCastle(fenPartitions[2]);
        boolean blackQueenSideCastle = FenUtil.blackQueenSideCastle(fenPartitions[2]);
        String gameConfiguration = fenPartitions[0];
        char[] boardTiles = gameConfiguration.replaceAll("/", "").replaceAll("8", "--------").replaceAll("7", "-------").replaceAll("6", "------").replaceAll("5", "-----").replaceAll("4", "----").replaceAll("3", "---").replaceAll("2", "--").replaceAll("1", "-").toCharArray();
        int i = 0;
        int enPassantCoordinate = -1;
        if (Arrays.stream(BoardUtils.ALGEBRAIC_NOTATION).anyMatch(fenPartitions[3]::equals)) {
            enPassantCoordinate = BoardUtils.getCoordinateAtPosition(fenPartitions[3]);
        }
        block15: while (i < boardTiles.length) {
            PawnPiece enPassantPawn;
            if (enPassantCoordinate != -1 && enPassantCoordinate == i - 8 && BoardUtils.SIXTH_RANK[enPassantCoordinate]) {
                enPassantPawn = new PawnPiece(PieceColor.BLACK, i);
                builder.setPiece(enPassantPawn);
                builder.setEnPassantPawn(enPassantPawn);
                ++i;
                continue;
            }
            if (enPassantCoordinate != -1 && enPassantCoordinate == i + 8 && BoardUtils.THIRD_RANK[enPassantCoordinate]) {
                enPassantPawn = new PawnPiece(PieceColor.WHITE, i);
                builder.setPiece(enPassantPawn);
                builder.setEnPassantPawn(enPassantPawn);
                ++i;
                continue;
            }
            switch (boardTiles[i]) {
                case 'r': {
                    builder.setPiece(new RookPiece(PieceColor.BLACK, i));
                    ++i;
                    continue block15;
                }
                case 'n': {
                    builder.setPiece(new KnightPiece(PieceColor.BLACK, i));
                    ++i;
                    continue block15;
                }
                case 'b': {
                    builder.setPiece(new BishopPiece(PieceColor.BLACK, i));
                    ++i;
                    continue block15;
                }
                case 'q': {
                    builder.setPiece(new QueenPiece(PieceColor.BLACK, i));
                    ++i;
                    continue block15;
                }
                case 'k': {
                    builder.setPiece(new KingPiece(PieceColor.BLACK, i, blackKingSideCastle, blackQueenSideCastle));
                    ++i;
                    continue block15;
                }
                case 'p': {
                    builder.setPiece(new PawnPiece(PieceColor.BLACK, i));
                    ++i;
                    continue block15;
                }
                case 'R': {
                    builder.setPiece(new RookPiece(PieceColor.WHITE, i));
                    ++i;
                    continue block15;
                }
                case 'N': {
                    builder.setPiece(new KnightPiece(PieceColor.WHITE, i));
                    ++i;
                    continue block15;
                }
                case 'B': {
                    builder.setPiece(new BishopPiece(PieceColor.WHITE, i));
                    ++i;
                    continue block15;
                }
                case 'Q': {
                    builder.setPiece(new QueenPiece(PieceColor.WHITE, i));
                    ++i;
                    continue block15;
                }
                case 'K': {
                    builder.setPiece(new KingPiece(PieceColor.WHITE, i, whiteKingSideCastle, whiteQueenSideCastle));
                    ++i;
                    continue block15;
                }
                case 'P': {
                    builder.setPiece(new PawnPiece(PieceColor.WHITE, i));
                    ++i;
                    continue block15;
                }
                case '-': {
                    ++i;
                    continue block15;
                }
            }
            throw new RuntimeException("Invalid FEN String " + gameConfiguration);
        }
        builder.setMoveMaker(FenUtil.moveMaker(fenPartitions[1]));
        return builder.build();
    }

    private static boolean checkIsFirstMove(Integer currentPos, String[] firstMoveList) {
        return Arrays.asList(firstMoveList).contains(currentPos.toString());
    }

    private static PieceColor moveMaker(String moveMakerString) {
        if (moveMakerString.equals("w")) {
            return PieceColor.WHITE;
        }
        if (moveMakerString.equals("b")) {
            return PieceColor.BLACK;
        }
        throw new RuntimeException("Invalid FEN String " + moveMakerString);
    }

    private static boolean whiteKingSideCastle(String fenCastleString) {
        return fenCastleString.contains("K");
    }

    private static boolean whiteQueenSideCastle(String fenCastleString) {
        return fenCastleString.contains("Q");
    }

    private static boolean blackKingSideCastle(String fenCastleString) {
        return fenCastleString.contains("k");
    }

    private static boolean blackQueenSideCastle(String fenCastleString) {
        return fenCastleString.contains("q");
    }

    private static String calculateCastleText(Board board) {
        String result;
        StringBuilder builder = new StringBuilder();
        if (board.getWhiteChessPlayer().isKingSideCastleCapable()) {
            builder.append("K");
        }
        if (board.getWhiteChessPlayer().isQueenSideCastleCapable()) {
            builder.append("Q");
        }
        if (board.getBlackChessPlayer().isKingSideCastleCapable()) {
            builder.append("k");
        }
        if (board.getBlackChessPlayer().isQueenSideCastleCapable()) {
            builder.append("q");
        }
        return (result = builder.toString()).isEmpty() ? "-" : result;
    }

    private static String calculateEnPassantSquare(Board board) {
        PawnPiece enPassantPawn = board.getEnPassantPawn();
        if (enPassantPawn != null) {
            return BoardUtils.getPositionAtCoordinate(enPassantPawn.getPiecePosition() + 8 * enPassantPawn.getPieceColor().getOppositeDirection());
        }
        return "-";
    }

    private static String calculateBoardText(Board board) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 64; ++i) {
            String tileText = board.getTile(i).getPiece() == null ? "-" : (board.getTile(i).getPiece().getPieceColor().isWhite() ? board.getTile(i).getPiece().toString() : board.getTile(i).getPiece().toString().toLowerCase());
            builder.append(tileText);
        }
        builder.insert(8, "/");
        builder.insert(17, "/");
        builder.insert(26, "/");
        builder.insert(35, "/");
        builder.insert(44, "/");
        builder.insert(53, "/");
        builder.insert(62, "/");
        return builder.toString().replaceAll("--------", "8").replaceAll("-------", "7").replaceAll("------", "6").replaceAll("-----", "5").replaceAll("----", "4").replaceAll("---", "3").replaceAll("--", "2").replaceAll("-", "1");
    }

    private static String calculateCurrentPlayerText(Board board) {
        return board.getCurrentChessPlayer().toString().substring(0, 1).toLowerCase();
    }

    public static boolean isFENValid(String FEN) {
        String[] FENInfo = FEN.split(" ");
        String[] boardTileInfo = FENInfo[0].split("/");
        int splitCounter = StringUtils.countMatches((CharSequence)FENInfo[0], (CharSequence)"/");
        int whiteKingCounter = StringUtils.countMatches((CharSequence)FENInfo[0], (CharSequence)"K");
        int blackKingCounter = StringUtils.countMatches((CharSequence)FENInfo[0], (CharSequence)"k");
        if (FENInfo.length != 6) {
            return false;
        }
        if (splitCounter != 7) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            String rowInfo = boardTileInfo[i];
            int valueCounter = 0;
            for (int j = 0; j < rowInfo.length(); ++j) {
                if (rowInfo.charAt(j) == '1') {
                    ++valueCounter;
                    continue;
                }
                if (rowInfo.charAt(j) == '2') {
                    valueCounter += 2;
                    continue;
                }
                if (rowInfo.charAt(j) == '3') {
                    valueCounter += 3;
                    continue;
                }
                if (rowInfo.charAt(j) == '4') {
                    valueCounter += 4;
                    continue;
                }
                if (rowInfo.charAt(j) == '5') {
                    valueCounter += 5;
                    continue;
                }
                if (rowInfo.charAt(j) == '6') {
                    valueCounter += 6;
                    continue;
                }
                if (rowInfo.charAt(j) == '7') {
                    valueCounter += 7;
                    continue;
                }
                if (rowInfo.charAt(j) == '8') {
                    valueCounter += 8;
                    continue;
                }
                ++valueCounter;
            }
            if (valueCounter == 8) continue;
            return false;
        }
        if (whiteKingCounter != 1) {
            return false;
        }
        if (blackKingCounter != 1) {
            return false;
        }
        if (!FENInfo[1].equals("w") && !FENInfo[1].equals("b")) {
            return false;
        }
        Board board = FenUtil.createGameFromFEN(FEN);
        if (board.getBlackChessPlayer().isInCheck() && board.getWhiteChessPlayer().isInCheck()) {
            return false;
        }
        if (FENInfo[1].equals("w") && board.getBlackChessPlayer().isInCheck()) {
            return false;
        }
        return !FENInfo[1].equals("b") || !board.getWhiteChessPlayer().isInCheck();
    }
}

