/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess.pieces;

import andrews.table_top_craft.game_logic.chess.PieceColor;
import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import java.util.Collection;

public abstract class BasePiece {
    protected final PieceType pieceType;
    protected final int piecePosition;
    protected final PieceColor pieceColor;
    protected final boolean isFirstMove;
    private final int cachedHashCode;

    BasePiece(PieceType pieceType, int piecePosition, PieceColor pieceColor, boolean isFirstMove) {
        this.pieceType = pieceType;
        this.piecePosition = piecePosition;
        this.pieceColor = pieceColor;
        this.isFirstMove = isFirstMove;
        this.cachedHashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        int result = this.pieceType.hashCode();
        result = 31 * result + this.pieceColor.hashCode();
        result = 31 * result + this.piecePosition;
        result = 31 * result + (this.isFirstMove ? 1 : 0);
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BasePiece)) {
            return false;
        }
        BasePiece otherPiece = (BasePiece)object;
        return this.piecePosition == otherPiece.getPiecePosition() && this.pieceType == otherPiece.getPieceType() && this.pieceColor == otherPiece.getPieceColor() && this.isFirstMove == otherPiece.isFirstMove();
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public int getPiecePosition() {
        return this.piecePosition;
    }

    public PieceColor getPieceColor() {
        return this.pieceColor;
    }

    public boolean isFirstMove() {
        return this.isFirstMove;
    }

    public PieceType getPieceType() {
        return this.pieceType;
    }

    public int getPieceValue() {
        return this.pieceType.getPieceValue();
    }

    public abstract Collection<BaseMove> calculateLegalMoves(Board var1);

    public abstract int locationBonus();

    public abstract BasePiece movePiece(BaseMove var1);

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum PieceType {
        PAWN(100, "P"){

            @Override
            public boolean isKing() {
                return false;
            }

            @Override
            public boolean isRook() {
                return false;
            }
        }
        ,
        KNIGHT(300, "N"){

            @Override
            public boolean isKing() {
                return false;
            }

            @Override
            public boolean isRook() {
                return false;
            }
        }
        ,
        BISHOP(300, "B"){

            @Override
            public boolean isKing() {
                return false;
            }

            @Override
            public boolean isRook() {
                return false;
            }
        }
        ,
        ROOK(500, "R"){

            @Override
            public boolean isKing() {
                return false;
            }

            @Override
            public boolean isRook() {
                return true;
            }
        }
        ,
        QUEEN(900, "Q"){

            @Override
            public boolean isKing() {
                return false;
            }

            @Override
            public boolean isRook() {
                return false;
            }
        }
        ,
        KING(10000, "K"){

            @Override
            public boolean isKing() {
                return true;
            }

            @Override
            public boolean isRook() {
                return false;
            }
        };

        private int pieceValue;
        private String pieceName;

        private PieceType(int pieceValue, String pieceName) {
            this.pieceValue = pieceValue;
            this.pieceName = pieceName;
        }

        public static PieceType get(int pieceType) {
            return switch (pieceType) {
                case 1 -> PAWN;
                case 2 -> ROOK;
                case 3 -> BISHOP;
                case 4 -> KNIGHT;
                case 5 -> KING;
                case 6 -> QUEEN;
                default -> null;
            };
        }

        public String toString() {
            return this.pieceName;
        }

        public int getPieceValue() {
            return this.pieceValue;
        }

        public abstract boolean isKing();

        public abstract boolean isRook();
    }

    public static enum PieceModelSet {
        STANDARD("models/pieces/%type%.obj"),
        CLASSIC("models/pieces/classic/classic_%type%.obj"),
        PANDORAS_CREATURES("models/pieces/pandoras_creatures/pc_%type%.obj");

        String PIECE_PATH;

        private PieceModelSet(String PIECE_PATH) {
            this.PIECE_PATH = PIECE_PATH;
        }

        public String pathFor(PieceType type) {
            return this.PIECE_PATH.replace("%type%", type.name().toLowerCase());
        }

        public static PieceModelSet get(int pieceSet) {
            return switch (pieceSet) {
                case 1 -> STANDARD;
                case 2 -> CLASSIC;
                case 3 -> PANDORAS_CREATURES;
                default -> null;
            };
        }
    }
}

