/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess.player.ai;

import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.game_logic.chess.player.BaseChessPlayer;
import java.util.Collection;
import java.util.stream.Collectors;

public final class PawnStructureAnalyzer {
    public static final int ISOLATED_PAWN_PENALTY = -10;
    public static final int DOUBLED_PAWN_PENALTY = -10;

    private PawnStructureAnalyzer() {
    }

    public int isolatedPawnPenalty(BaseChessPlayer player) {
        return PawnStructureAnalyzer.calculateIsolatedPawnPenalty(PawnStructureAnalyzer.createPawnColumnTable(PawnStructureAnalyzer.calculatePlayerPawns(player)));
    }

    public int doubledPawnPenalty(BaseChessPlayer player) {
        return PawnStructureAnalyzer.calculatePawnColumnStack(PawnStructureAnalyzer.createPawnColumnTable(PawnStructureAnalyzer.calculatePlayerPawns(player)));
    }

    public static int pawnStructureScore(BaseChessPlayer player) {
        int[] pawnsOnColumnTable = PawnStructureAnalyzer.createPawnColumnTable(PawnStructureAnalyzer.calculatePlayerPawns(player));
        return PawnStructureAnalyzer.calculatePawnColumnStack(pawnsOnColumnTable) + PawnStructureAnalyzer.calculateIsolatedPawnPenalty(pawnsOnColumnTable);
    }

    private static Collection<BasePiece> calculatePlayerPawns(BaseChessPlayer player) {
        return player.getActivePieces().stream().filter(piece -> piece.getPieceType() == BasePiece.PieceType.PAWN).collect(Collectors.toList());
    }

    private static int calculatePawnColumnStack(int[] pawnsOnColumnTable) {
        int pawnStackPenalty = 0;
        for (int pawnStack : pawnsOnColumnTable) {
            if (pawnStack <= 1) continue;
            pawnStackPenalty += pawnStack;
        }
        return pawnStackPenalty * -10;
    }

    private static int calculateIsolatedPawnPenalty(int[] pawnsOnColumnTable) {
        int numIsolatedPawns = 0;
        if (pawnsOnColumnTable[0] > 0 && pawnsOnColumnTable[1] == 0) {
            numIsolatedPawns += pawnsOnColumnTable[0];
        }
        if (pawnsOnColumnTable[7] > 0 && pawnsOnColumnTable[6] == 0) {
            numIsolatedPawns += pawnsOnColumnTable[7];
        }
        for (int i = 1; i < pawnsOnColumnTable.length - 1; ++i) {
            if (pawnsOnColumnTable[i - 1] != 0 || pawnsOnColumnTable[i + 1] != 0) continue;
            numIsolatedPawns += pawnsOnColumnTable[i];
        }
        return numIsolatedPawns * -10;
    }

    private static int[] createPawnColumnTable(Collection<BasePiece> playerPawns) {
        int[] table = new int[8];
        for (BasePiece playerPawn : playerPawns) {
            int n = playerPawn.getPiecePosition() % 8;
            table[n] = table[n] + 1;
        }
        return table;
    }
}

