/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.objects.blocks;

import andrews.table_top_craft.block_entities.ConnectFourBlockEntity;
import andrews.table_top_craft.util.Color;
import andrews.table_top_craft.util.NetworkUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConnectFourBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape BASE_X = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)2.0, (double)10.0);
    private static final VoxelShape LEFT_POLE_X = Block.m_49796_((double)0.5, (double)2.0, (double)7.0, (double)1.5, (double)14.0, (double)9.0);
    private static final VoxelShape RIGHT_POLE_X = Block.m_49796_((double)14.5, (double)2.0, (double)7.0, (double)15.5, (double)14.0, (double)9.0);
    private static final VoxelShape CENTER_X = Block.m_49796_((double)1.5, (double)2.0, (double)7.5, (double)14.5, (double)13.0, (double)8.5);
    private static final VoxelShape BASE_Y = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)2.0, (double)16.0);
    private static final VoxelShape LEFT_POLE_Y = Block.m_49796_((double)7.0, (double)2.0, (double)0.5, (double)9.0, (double)14.0, (double)1.5);
    private static final VoxelShape RIGHT_POLE_Y = Block.m_49796_((double)7.0, (double)2.0, (double)14.5, (double)9.0, (double)14.0, (double)15.5);
    private static final VoxelShape CENTER_Y = Block.m_49796_((double)7.5, (double)2.0, (double)1.5, (double)8.5, (double)13.0, (double)14.5);
    private static final VoxelShape X_AXIS_AABB = Shapes.m_83124_((VoxelShape)BASE_X, (VoxelShape[])new VoxelShape[]{LEFT_POLE_X, RIGHT_POLE_X, CENTER_X});
    private static final VoxelShape Y_AXIS_AABB = Shapes.m_83124_((VoxelShape)BASE_Y, (VoxelShape[])new VoxelShape[]{LEFT_POLE_Y, RIGHT_POLE_Y, CENTER_Y});

    public ConnectFourBlock(MapColor mapColor, SoundType soundType) {
        super(ConnectFourBlock.getProperties(mapColor, soundType));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    private static BlockBehaviour.Properties getProperties(MapColor mapColor, SoundType soundType) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();
        properties.m_284180_(MapColor.f_283825_);
        properties.m_60918_(soundType);
        properties.m_60978_(2.0f);
        properties.m_60955_();
        return properties;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Direction blockFace = (Direction)state.m_61143_((Property)FACING);
        Direction hitFace = hit.m_82434_();
        if (player.m_6144_()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ConnectFourBlockEntity) {
                ConnectFourBlockEntity blockEntity2 = (ConnectFourBlockEntity)blockEntity;
                blockEntity2.reset();
                level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 2);
                blockEntity2.m_6596_();
                return InteractionResult.SUCCESS;
            }
        } else if ((hitFace.equals((Object)blockFace) || hitFace.equals((Object)blockFace.m_122424_())) && hit.m_82450_().f_82480_ - (double)pos.m_123342_() > 0.125 && hit.m_82450_().f_82480_ - (double)pos.m_123342_() < 0.8125 && ((blockFace.equals((Object)Direction.NORTH) || blockFace.equals((Object)Direction.SOUTH)) && hit.m_82450_().f_82481_ - (double)pos.m_123343_() < (double)0.56f && hit.m_82450_().f_82481_ - (double)pos.m_123343_() > (double)0.44f || (blockFace.equals((Object)Direction.EAST) || blockFace.equals((Object)Direction.WEST)) && hit.m_82450_().f_82479_ - (double)pos.m_123341_() < (double)0.56f && hit.m_82450_().f_82479_ - (double)pos.m_123341_() > (double)0.44f)) {
            byte column = (byte)this.getClickedColumn(hit.m_82450_(), blockFace);
            byte row = (byte)this.getClickedRow(hit.m_82450_());
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ConnectFourBlockEntity) {
                ConnectFourBlockEntity blockEntity3 = (ConnectFourBlockEntity)blockEntity;
                Item item = player.m_21120_(hand).m_41720_();
                if (item instanceof DyeItem) {
                    DyeItem dyeItem = (DyeItem)item;
                    if (blockEntity3.getColumns()[column].charAt(row) == 'i' || blockEntity3.getColumns()[column].charAt(row) == 'g') {
                        float[] rgb = dyeItem.m_41089_().m_41068_();
                        int red = Mth.m_14045_((int)Math.round(255.0f * rgb[0]), (int)0, (int)255);
                        int green = Mth.m_14045_((int)Math.round(255.0f * rgb[1]), (int)0, (int)255);
                        int blue = Mth.m_14045_((int)Math.round(255.0f * rgb[2]), (int)0, (int)255);
                        Color color = new Color(red, green, blue);
                        if (blockEntity3.getColumns()[column].charAt(row) == 'i') {
                            blockEntity3.ironColor = color.getRGB();
                        } else {
                            blockEntity3.goldColor = color.getRGB();
                        }
                        level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 2);
                        blockEntity3.m_6596_();
                        if (!player.m_7500_()) {
                            player.m_21120_(hand).m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.CONSUME;
                }
                if (blockEntity3.hasFourInARow() || blockEntity3.getTopPieceInColumn(column) == 5) {
                    return InteractionResult.CONSUME;
                }
            }
            if (level.m_5776_()) {
                NetworkUtil.doConnectFourInteraction(pos, column);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> Y_AXIS_AABB;
            case Direction.NORTH, Direction.SOUTH -> X_AXIS_AABB;
        };
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ConnectFourBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return (level1, pos, state1, blockEntity) -> ConnectFourBlockEntity.tick(level1, pos, state1, (ConnectFourBlockEntity)blockEntity);
    }

    private int getClickedColumn(Vec3 vec3d, Direction facing) {
        double value = facing.equals((Object)Direction.NORTH) || facing.equals((Object)Direction.SOUTH) ? vec3d.f_82479_ : vec3d.f_82481_;
        value -= Math.floor(value);
        return (int)(Math.floor((value *= 100.0) / 6.25) - 1.0) / 2;
    }

    private int getClickedRow(Vec3 vec3d) {
        double value = vec3d.f_82480_;
        value -= Math.floor(value);
        return (int)Mth.m_14008_((double)((Math.floor((value *= 100.0) / 3.125) - 3.0) / 4.0), (double)0.0, (double)5.0);
    }
}

