/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.objects.blocks;

import andrews.table_top_craft.block_entities.TicTacToeBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TicTacToeBlock
extends BaseEntityBlock {
    private static final VoxelShape AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)0.5, (double)15.0);

    public TicTacToeBlock() {
        super(TicTacToeBlock.getProperties());
    }

    private static BlockBehaviour.Properties getProperties() {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();
        properties.m_284180_(MapColor.f_283930_);
        properties.m_60978_(0.2f);
        properties.m_60918_(SoundType.f_154670_);
        return properties;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AABB;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Direction face = hit.m_82434_();
        if (face.equals((Object)Direction.UP)) {
            int tile = this.getTile(hit.m_82450_());
            int column = this.getColumn(hit.m_82450_());
            byte tileCoordinate = (byte)Mth.m_14045_((int)((3 - tile) * 3 + column), (int)0, (int)9);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof TicTacToeBlockEntity) {
                TicTacToeBlockEntity ticTacToeBlockEntity = (TicTacToeBlockEntity)blockEntity;
                char[] chars = ticTacToeBlockEntity.getTicTacToeGame().replaceAll("/", "").toCharArray();
                if (player.m_6144_()) {
                    ticTacToeBlockEntity.setTicTacToeGame("---/---/---");
                    ticTacToeBlockEntity.resetFrames();
                    level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 2);
                    ticTacToeBlockEntity.m_6596_();
                    return InteractionResult.SUCCESS;
                }
                Item item = player.m_21120_(hand).m_41720_();
                if (item instanceof DyeItem) {
                    DyeItem dyeItem = (DyeItem)item;
                    if (ticTacToeBlockEntity.getTicTacToeCharAt(tileCoordinate - 1) == '-') {
                        return InteractionResult.CONSUME;
                    }
                    float[] rgb = dyeItem.m_41089_().m_41068_();
                    int red = Mth.m_14045_((int)Math.round(255.0f * rgb[0]), (int)0, (int)255);
                    int green = Mth.m_14045_((int)Math.round(255.0f * rgb[1]), (int)0, (int)255);
                    int blue = Mth.m_14045_((int)Math.round(255.0f * rgb[2]), (int)0, (int)255);
                    this.setProperColor(tileCoordinate - 1, ticTacToeBlockEntity, red + "/" + green + "/" + blue);
                    level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 2);
                    if (!player.m_7500_()) {
                        player.m_21120_(hand).m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (!ticTacToeBlockEntity.isGameOver(ticTacToeBlockEntity.getTicTacToeGame())) {
                    if (chars[tileCoordinate - 1] == '-') {
                        chars[tileCoordinate - 1] = this.getEmptyTiles(chars) % 2 == 0 ? 79 : 88;
                        ticTacToeBlockEntity.setTicTacToeFrameAt(0, tileCoordinate - 1);
                    }
                    chars = new char[]{chars[0], chars[1], chars[2], '/', chars[3], chars[4], chars[5], '/', chars[6], chars[7], chars[8]};
                    ticTacToeBlockEntity.setTicTacToeGame(String.valueOf(chars));
                    level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 2);
                    ticTacToeBlockEntity.m_6596_();
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void setProperColor(int tileCoordinate, TicTacToeBlockEntity ticTacToeBlockEntity, String color) {
        if (ticTacToeBlockEntity.getTicTacToeCharAt(tileCoordinate) != '-') {
            if (ticTacToeBlockEntity.getTicTacToeCharAt(tileCoordinate) == 'O') {
                ticTacToeBlockEntity.setCircleColor(color);
            } else {
                ticTacToeBlockEntity.setCrossColor(color);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TicTacToeBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return (level1, pos, state1, blockEntity) -> TicTacToeBlockEntity.tick(level1, pos, state1, (TicTacToeBlockEntity)blockEntity);
    }

    private int getTile(Vec3 vec3d) {
        double value = -vec3d.f_82479_;
        value -= Math.floor(value);
        return (int)(3.0 - Math.floor((value *= 100.0) / 33.3));
    }

    private int getColumn(Vec3 vec3d) {
        double value = -vec3d.f_82481_;
        value -= Math.floor(value);
        return (int)(3.0 - Math.floor((value *= 100.0) / 33.3));
    }

    private int getEmptyTiles(char[] game) {
        int emptyTiles = 0;
        for (char chars : game) {
            if (chars != '-') continue;
            ++emptyTiles;
        }
        return emptyTiles;
    }
}

