/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.screens.chess_timer.buttons;

import andrews.table_top_craft.block_entities.ChessTimerBlockEntity;
import andrews.table_top_craft.objects.blocks.ChessTimerBlock;
import andrews.table_top_craft.util.NetworkUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;

public class ChessTimerTimeAlteringButton
extends AbstractButton {
    private static final ResourceLocation BUTTONS_TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/buttons/chess_timer_buttons.png");
    private static final String HOUR = "gui.table_top_craft.chess_timer.buttons.hour";
    private static final String HOURS = "gui.table_top_craft.chess_timer.buttons.hours";
    private static final String MINUTE = "gui.table_top_craft.chess_timer.buttons.minute";
    private static final String MINUTES = "gui.table_top_craft.chess_timer.buttons.minutes";
    private static final String SECOND = "gui.table_top_craft.chess_timer.buttons.second";
    private static final String SECONDS = "gui.table_top_craft.chess_timer.buttons.seconds";
    private final ChessTimerBlockEntity blockEntity;
    private final TimeModifierType type;
    private final TimeCategory category;

    public ChessTimerTimeAlteringButton(ChessTimerBlockEntity blockEntity, int x, int y, TimeModifierType type, TimeCategory category) {
        super(x, y, 13, 13, (Component)Component.m_237113_((String)""));
        this.blockEntity = blockEntity;
        this.type = type;
        this.category = category;
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        BlockState state;
        this.f_93623_ = false;
        if (Minecraft.m_91087_().f_91073_ != null && ((ChessTimerBlock.PressedButton)((Object)(state = Minecraft.m_91087_().f_91073_.m_8055_(this.blockEntity.m_58899_())).m_61143_(ChessTimerBlock.PRESSED_BUTTON))).equals((Object)ChessTimerBlock.PressedButton.NONE)) {
            this.f_93623_ = true;
        }
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280218_(BUTTONS_TEXTURE, this.f_93620_, this.f_93621_, this.m_142518_() ? (this.m_198029_() ? 13 : 0) : 26, this.type.getTexturePos(), 13, 13);
        if (this.m_274382_() && this.m_142518_()) {
            graphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)(switch (this.category) {
                case TimeCategory.LEFT_HOUR, TimeCategory.RIGHT_HOUR -> this.type.equals((Object)TimeModifierType.INCREASE_BIG) || this.type.equals((Object)TimeModifierType.DECREASE_BIG) ? Component.m_237110_((String)HOURS, (Object[])new Object[]{(this.type.equals((Object)TimeModifierType.INCREASE_BIG) ? "+" : "-") + Mth.m_14040_((int)this.type.getModifier())}) : Component.m_237110_((String)HOUR, (Object[])new Object[]{(this.type.equals((Object)TimeModifierType.INCREASE_NORMAL) ? "+" : "-") + Mth.m_14040_((int)this.type.getModifier())});
                case TimeCategory.LEFT_MINUTE, TimeCategory.RIGHT_MINUTE -> this.type.equals((Object)TimeModifierType.INCREASE_BIG) || this.type.equals((Object)TimeModifierType.DECREASE_BIG) ? Component.m_237110_((String)MINUTES, (Object[])new Object[]{(this.type.equals((Object)TimeModifierType.INCREASE_BIG) ? "+" : "-") + Mth.m_14040_((int)this.type.getModifier())}) : Component.m_237110_((String)MINUTE, (Object[])new Object[]{(this.type.equals((Object)TimeModifierType.INCREASE_NORMAL) ? "+" : "-") + Mth.m_14040_((int)this.type.getModifier())});
                case TimeCategory.LEFT_SECOND, TimeCategory.RIGHT_SECOND -> this.type.equals((Object)TimeModifierType.INCREASE_BIG) || this.type.equals((Object)TimeModifierType.DECREASE_BIG) ? Component.m_237110_((String)SECONDS, (Object[])new Object[]{(this.type.equals((Object)TimeModifierType.INCREASE_BIG) ? "+" : "-") + Mth.m_14040_((int)this.type.getModifier())}) : Component.m_237110_((String)SECOND, (Object[])new Object[]{(this.type.equals((Object)TimeModifierType.INCREASE_NORMAL) ? "+" : "-") + Mth.m_14040_((int)this.type.getModifier())});
                default -> Component.m_237113_((String)"");
            }), mouseX, mouseY);
        }
    }

    protected void m_168797_(NarrationElementOutput output) {
        this.m_168802_(output);
    }

    public void m_5691_() {
        NetworkUtil.adjustChessTimerTime(this.blockEntity.m_58899_(), this.type.getIdx(), this.category.getIdx());
    }

    public static enum TimeModifierType {
        INCREASE_BIG(0, 10, 0, 30),
        INCREASE_NORMAL(1, 1, 13, 45),
        DECREASE_NORMAL(2, -1, 26, 71),
        DECREASE_BIG(3, -10, 39, 86);

        private final byte idx;
        private final int modifier;
        private final int texturePos;
        private final int offsetY;

        private TimeModifierType(byte idx, int modifier, int texturePos, int offsetY) {
            this.idx = idx;
            this.modifier = modifier;
            this.texturePos = texturePos;
            this.offsetY = offsetY;
        }

        public byte getIdx() {
            return this.idx;
        }

        public int getModifier() {
            return this.modifier;
        }

        public int getTexturePos() {
            return this.texturePos;
        }

        public int getOffsetY() {
            return this.offsetY;
        }
    }

    public static enum TimeCategory {
        LEFT_HOUR(0, 3600000L, 12),
        LEFT_MINUTE(1, 60000L, 34),
        LEFT_SECOND(2, 1000L, 56),
        RIGHT_HOUR(3, 3600000L, 88),
        RIGHT_MINUTE(4, 60000L, 110),
        RIGHT_SECOND(5, 1000L, 132);

        private final byte idx;
        private final long millis;
        private final int offsetX;

        private TimeCategory(byte idx, long millis, int offsetX) {
            this.idx = idx;
            this.millis = millis;
            this.offsetX = offsetX;
        }

        public byte getIdx() {
            return this.idx;
        }

        public long getMillis() {
            return this.millis;
        }

        public int getOffsetX() {
            return this.offsetX;
        }
    }
}

