/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.util;

import andrews.table_top_craft.animation.model.AdvancedModelPart;
import andrews.table_top_craft.util.TTCRenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Vector3f;

public class TTCRenderUtil {
    public static void renderLine(MultiBufferSource buffer, PoseStack poseStack, int red, int green, int blue, float startX, float startY, float startZ, float endX, float endY, float endZ) {
        VertexConsumer builder = buffer.m_6299_(TTCRenderTypes.skeletonDebugLines());
        builder.m_252986_(poseStack.m_85850_().m_252922_(), startX, startY, startZ);
        builder.m_6122_(red, green, blue, 255);
        builder.m_5752_();
        builder.m_252986_(poseStack.m_85850_().m_252922_(), endX, endY, endZ);
        builder.m_6122_(red, green, blue, 255);
        builder.m_5752_();
    }

    public static void renderText(Component text, float posX, float posY, float posZ, float scale, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
    }

    public static void renderQuad(MultiBufferSource buffer, PoseStack poseStack, int red, int green, int blue, float posX, float posY, float posZ, float size) {
        float scale = size / 2.0f;
        VertexConsumer builder = buffer.m_6299_(TTCRenderTypes.skeletonDebugQuad());
        poseStack.m_85836_();
        poseStack.m_252880_(posX, posY, posZ);
        poseStack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        builder.m_252986_(poseStack.m_85850_().m_252922_(), -scale, scale, 0.0f);
        builder.m_6122_(red, green, blue, 255);
        builder.m_5752_();
        builder.m_252986_(poseStack.m_85850_().m_252922_(), scale, scale, 0.0f);
        builder.m_6122_(red, green, blue, 255);
        builder.m_5752_();
        builder.m_252986_(poseStack.m_85850_().m_252922_(), scale, -scale, 0.0f);
        builder.m_6122_(red, green, blue, 255);
        builder.m_5752_();
        builder.m_252986_(poseStack.m_85850_().m_252922_(), -scale, -scale, 0.0f);
        builder.m_6122_(red, green, blue, 255);
        builder.m_5752_();
        poseStack.m_85849_();
    }

    public static void renderCross(MultiBufferSource buffer, PoseStack poseStack, int red, int green, int blue, float xPos, float yPos, float zPos, float size) {
        TTCRenderUtil.renderLine(buffer, poseStack, red, green, blue, xPos - size / 2.0f, yPos, zPos, xPos + size / 2.0f, yPos, zPos);
        TTCRenderUtil.renderLine(buffer, poseStack, red, green, blue, xPos, yPos - size / 2.0f, zPos, xPos, yPos + size / 2.0f, zPos);
        TTCRenderUtil.renderLine(buffer, poseStack, red, green, blue, xPos, yPos, zPos - size / 2.0f, xPos, yPos, zPos + size / 2.0f);
    }

    public static void renderCross(LivingEntity entity, MultiBufferSource buffer, PoseStack poseStack, float xPos, float yPos, float zPos, float xRot, float yRot, float zRot, float size) {
        poseStack.m_85836_();
        poseStack.m_252880_(xPos, yPos, zPos);
        poseStack.m_252781_(Axis.f_252392_.m_252977_(Mth.m_14179_((float)Minecraft.m_91087_().getPartialTick(), (float)entity.f_20884_, (float)entity.f_20883_)));
        poseStack.m_252781_(Axis.f_252393_.m_252961_(zRot));
        poseStack.m_252781_(Axis.f_252392_.m_252961_(yRot));
        poseStack.m_252781_(Axis.f_252529_.m_252961_(xRot));
        TTCRenderUtil.renderLine(buffer, poseStack, 255, 0, 0, -size / 2.0f, 0.0f, 0.0f, size / 2.0f, 0.0f, 0.0f);
        TTCRenderUtil.renderLine(buffer, poseStack, 0, 255, 0, 0.0f, -size / 2.0f, 0.0f, 0.0f, size / 2.0f, 0.0f);
        TTCRenderUtil.renderLine(buffer, poseStack, 0, 0, 255, 0.0f, 0.0f, -size / 2.0f, 0.0f, 0.0f, size / 2.0f);
        poseStack.m_85849_();
    }

    public static void renderChainFromModelPart(LivingEntity entity, MultiBufferSource buffer, PoseStack poseStack, AdvancedModelPart part, int packedLight, boolean showNames) {
        ArrayList<Vector3f> partCoords = new ArrayList<Vector3f>();
        ArrayList<String> partNames = new ArrayList<String>();
        while (part != null) {
            partCoords.add(part.getModelSpace((Entity)entity));
            partNames.add(part.getName());
            part = part.getParent();
        }
        for (int i = 1; i < partCoords.size(); ++i) {
            Vector3f start = (Vector3f)partCoords.get(i - 1);
            Vector3f end = (Vector3f)partCoords.get(i);
            TTCRenderUtil.renderLine(buffer, poseStack, 0, 255, 100, start.x, start.y, start.z, end.x, end.y, end.z);
        }
        for (Vector3f pos : partCoords) {
            TTCRenderUtil.renderQuad(buffer, poseStack, 255, 255, 255, pos.x, pos.y, pos.z, 0.02f);
        }
        if (showNames) {
            for (int i = 0; i < partCoords.size(); ++i) {
                Vector3f pos;
                pos = (Vector3f)partCoords.get(i);
                String name = (String)partNames.get(i);
                TTCRenderUtil.renderText((Component)Component.m_237113_((String)name), pos.x, pos.y + 0.05f, pos.z, 0.2f, poseStack, buffer, packedLight);
            }
        }
    }
}

