/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class BlockTypeRegistry<T extends BlockType> {
    protected boolean frozen = false;
    private final String name;
    private final List<BlockType.SetFinder<T>> finders = new ArrayList<BlockType.SetFinder<T>>();
    private final List<ResourceLocation> notInclude = new ArrayList<ResourceLocation>();
    protected final List<T> builder = new ArrayList<T>();
    private final Class<T> typeClass;
    private Map<ResourceLocation, T> types = new LinkedHashMap<ResourceLocation, T>();
    private final Object2ObjectOpenHashMap<Object, T> childrenToType = new Object2ObjectOpenHashMap();

    public static Codec<BlockTypeRegistry<?>> getRegistryCodec() {
        return BlockSetInternal.getRegistriesCodec();
    }

    protected BlockTypeRegistry(Class<T> typeClass, String name) {
        this.typeClass = typeClass;
        this.name = name;
    }

    public Class<T> getType() {
        return this.typeClass;
    }

    public T getFromNBT(String name) {
        return (T)((BlockType)this.types.getOrDefault(new ResourceLocation(name), this.getDefaultType()));
    }

    @Nullable
    public T get(ResourceLocation res) {
        return (T)((BlockType)this.types.get(res));
    }

    public abstract T getDefaultType();

    public Collection<T> getValues() {
        return Collections.unmodifiableCollection(this.types.values());
    }

    public String typeName() {
        return this.name;
    }

    public abstract Optional<T> detectTypeFromBlock(Block var1, ResourceLocation var2);

    public void registerBlockType(T newType) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried to register a wood types after registry events");
        }
        this.builder.add(newType);
    }

    public Collection<BlockType.SetFinder<T>> getFinders() {
        return this.finders;
    }

    public void addFinder(BlockType.SetFinder<T> finder) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried to register a block type finder after registry events");
        }
        this.finders.add(finder);
    }

    public void addRemover(ResourceLocation id) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried remove a block type after registry events");
        }
        this.notInclude.add(id);
    }

    protected void finalizeAndFreeze() {
        if (this.frozen) {
            throw new UnsupportedOperationException("Block types are already finalized");
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        ArrayList<String> modOrder = new ArrayList<String>();
        modOrder.add("minecraft");
        this.builder.forEach(e -> {
            String modId = e.getNamespace();
            if (!modOrder.contains(modId)) {
                modOrder.add(modId);
            }
        });
        for (String modId : modOrder) {
            this.builder.forEach(e -> {
                if (Objects.equals(e.getNamespace(), modId) && !linkedHashMap.containsKey(e.getId())) {
                    linkedHashMap.put(e.getId(), e);
                }
            });
        }
        this.types = ImmutableMap.copyOf(linkedHashMap);
        this.builder.clear();
        this.frozen = true;
    }

    @ApiStatus.Internal
    public void onBlockInit() {
        this.types.values().forEach(BlockType::initializeChildrenBlocks);
    }

    @ApiStatus.Internal
    public void onItemInit() {
        this.types.values().forEach(BlockType::initializeChildrenItems);
    }

    @ApiStatus.Internal
    public void buildAll() {
        if (!this.frozen) {
            this.registerBlockType(this.getDefaultType());
            this.finders.stream().map(BlockType.SetFinder::get).forEach(f -> f.ifPresent(this::registerBlockType));
            for (Block b : BuiltInRegistries.f_256975_) {
                this.detectTypeFromBlock(b, Utils.getID(b)).ifPresent(t -> {
                    if (!this.notInclude.contains(t.getId())) {
                        this.registerBlockType(t);
                    }
                });
            }
            this.finders.clear();
            this.notInclude.clear();
            this.finalizeAndFreeze();
        }
    }

    public void addTypeTranslations(AfterLanguageLoadEvent language) {
    }

    @Nullable
    public T getBlockTypeOf(ItemLike itemLike) {
        BlockType fist = (BlockType)this.childrenToType.getOrDefault((Object)itemLike, null);
        if (fist != null) {
            return (T)fist;
        }
        if (itemLike instanceof BlockItem) {
            BlockItem bi = (BlockItem)itemLike;
            return (T)((BlockType)this.childrenToType.getOrDefault((Object)bi.m_40614_(), null));
        }
        return null;
    }

    protected void mapObjectToType(Object itemLike, BlockType type) {
        BlockItem bi;
        this.childrenToType.put(itemLike, (Object)type);
        if (itemLike instanceof BlockItem && !this.childrenToType.containsKey((Object)(bi = (BlockItem)itemLike).m_5456_())) {
            this.childrenToType.put((Object)bi.m_5456_(), (Object)type);
        }
    }

    public int priority() {
        return 100;
    }
}

