/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.event.RenderItemInHandBobEvent;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.client.other.KeepingItemRenderer;
import com.tacz.guns.api.event.common.GunFireEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.client.animation.screen.RefitTransform;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateMachine;
import com.tacz.guns.client.model.BedrockAttachmentModel;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.client.model.functional.MuzzleFlashRender;
import com.tacz.guns.client.model.functional.ShellRender;
import com.tacz.guns.client.resource.InternalAssetLoader;
import com.tacz.guns.client.resource.index.ClientAttachmentIndex;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.util.math.Easing;
import com.tacz.guns.util.math.MathUtil;
import com.tacz.guns.util.math.PerlinNoise;
import com.tacz.guns.util.math.SecondOrderDynamics;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tacz")
public class FirstPersonRenderGunEvent {
    private static final SecondOrderDynamics AIMING_DYNAMICS = new SecondOrderDynamics(1.2f, 1.2f, 0.5f, 0.0f);
    private static final SecondOrderDynamics REFIT_OPENING_DYNAMICS = new SecondOrderDynamics(1.0f, 1.2f, 0.5f, 0.0f);
    private static final SecondOrderDynamics JUMPING_DYNAMICS = new SecondOrderDynamics(0.28f, 1.0f, 0.65f, 0.0f);
    private static final float JUMPING_Y_SWAY = -2.0f;
    private static final float JUMPING_SWAY_TIME = 0.3f;
    private static final float LANDING_SWAY_TIME = 0.15f;
    private static final PerlinNoise SHOOT_X_SWAY_NOISE = new PerlinNoise(-0.2f, 0.2f, 400L);
    private static final PerlinNoise SHOOT_Y_ROTATION_NOISE = new PerlinNoise(-0.0136f, 0.0136f, 100L);
    private static final float SHOOT_Y_SWAY = -0.1f;
    private static final float SHOOT_ANIMATION_TIME = 0.3f;
    private static float jumpingSwayProgress = 0.0f;
    private static boolean lastOnGround = false;
    private static long jumpingTimeStamp = -1L;
    private static long shootTimeStamp = -1L;

    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (event.getHand() == InteractionHand.OFF_HAND) {
            ItemStack stack = KeepingItemRenderer.getRenderer().getCurrentItem();
            if (stack.m_41720_() instanceof IGun) {
                event.setCanceled(true);
            }
            return;
        }
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        ItemDisplayContext transformType = event.getHand() == InteractionHand.MAIN_HAND ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
        ResourceLocation gunId = iGun.getGunId(stack);
        TimelessAPI.getClientGunIndex(gunId).ifPresentOrElse(gunIndex -> {
            BedrockGunModel gunModel = gunIndex.getGunModel();
            GunAnimationStateMachine animationStateMachine = gunIndex.getAnimationStateMachine();
            if (gunModel == null) {
                return;
            }
            if (animationStateMachine != null) {
                animationStateMachine.update(event.getPartialTick(), (Entity)player);
            }
            PoseStack poseStack = event.getPoseStack();
            poseStack.m_85836_();
            float xRotOffset = Mth.m_14179_((float)event.getPartialTick(), (float)player.f_108588_, (float)player.f_108586_);
            float yRotOffset = Mth.m_14179_((float)event.getPartialTick(), (float)player.f_108587_, (float)player.f_108585_);
            float xRot = player.m_5686_(event.getPartialTick()) - xRotOffset;
            float yRot = player.m_5675_(event.getPartialTick()) - yRotOffset;
            poseStack.m_252781_(Axis.f_252529_.m_252977_(xRot * -0.1f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(yRot * -0.1f));
            BedrockPart rootNode = gunModel.getRootNode();
            if (rootNode != null) {
                xRot = (float)Math.tanh(xRot / 25.0f) * 25.0f;
                yRot = (float)Math.tanh(yRot / 25.0f) * 25.0f;
                rootNode.offsetX += yRot * 0.1f / 16.0f / 3.0f;
                rootNode.offsetY += -xRot * 0.1f / 16.0f / 3.0f;
                rootNode.additionalQuaternion.mul((Quaternionfc)Axis.f_252529_.m_252977_(xRot * 0.05f));
                rootNode.additionalQuaternion.mul((Quaternionfc)Axis.f_252436_.m_252977_(yRot * 0.05f));
            }
            poseStack.m_252880_(0.0f, 1.5f, 0.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            FirstPersonRenderGunEvent.applyFirstPersonGunTransform(player, stack, gunIndex, poseStack, gunModel, event.getPartialTick());
            MuzzleFlashRender.isSelf = true;
            ShellRender.isSelf = true;
            boolean renderHand = gunModel.getRenderHand();
            if (RefitTransform.getOpeningProgress() != 0.0f) {
                gunModel.setRenderHand(false);
            }
            RenderType renderType = RenderType.m_110452_((ResourceLocation)gunIndex.getModelTexture());
            gunModel.render(poseStack, stack, transformType, renderType, event.getPackedLight(), OverlayTexture.f_118083_);
            FirstPersonRenderGunEvent.renderBulletTracer(player, poseStack, gunModel, event.getPartialTick());
            gunModel.setRenderHand(renderHand);
            poseStack.m_85849_();
            gunModel.cleanAnimationTransform();
            MuzzleFlashRender.isSelf = false;
            ShellRender.isSelf = false;
            event.setCanceled(true);
        }, () -> FirstPersonRenderGunEvent.renderBulletTracer(player, event.getPoseStack(), null, event.getPartialTick()));
    }

    private static void renderBulletTracer(LocalPlayer player, PoseStack poseStack, BedrockGunModel gunModel, float partialTicks) {
        if (!((Boolean)RenderConfig.FIRST_PERSON_BULLET_TRACER_ENABLE.get()).booleanValue()) {
            return;
        }
        Optional<BedrockModel> modelOptional = InternalAssetLoader.getBedrockModel(InternalAssetLoader.DEFAULT_BULLET_MODEL);
        if (modelOptional.isEmpty()) {
            return;
        }
        BedrockModel model = modelOptional.get();
        Level level = player.m_9236_();
        AABB renderArea = player.m_20191_().m_82377_(256.0, 256.0, 256.0);
        for (Entity entity : level.m_6249_((Entity)player, renderArea, FirstPersonRenderGunEvent::bulletFromPlayer)) {
            EntityKineticBullet entityBullet = (EntityKineticBullet)entity;
            if (!entityBullet.isTracerAmmo()) continue;
            Vec3 deltaMovement = entityBullet.m_20184_().m_82542_((double)partialTicks, (double)partialTicks, (double)partialTicks);
            Vec3 entityPosition = entityBullet.m_20318_(0.0f).m_82549_(deltaMovement);
            Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
            Vec3 cameraPosition = camera.m_90583_();
            Vec3 originCameraPosition = entityBullet.getOriginCameraPosition();
            if (originCameraPosition == null) {
                if (gunModel == null || gunModel.getMuzzleFlashPosPath() == null) continue;
                poseStack.m_85836_();
                for (BedrockPart bedrockPart : gunModel.getMuzzleFlashPosPath()) {
                    bedrockPart.translateAndRotateAndScale(poseStack);
                }
                Matrix4f pose = poseStack.m_85850_().m_252922_();
                originCameraPosition = new Vec3(cameraPosition.f_82479_, cameraPosition.f_82480_, cameraPosition.f_82481_);
                entityBullet.setOriginCameraPosition(originCameraPosition);
                entityBullet.setOriginRenderOffset(new Vec3((double)pose.m30(), (double)pose.m31(), (double)pose.m32()));
                poseStack.m_85849_();
            }
            Vec3 originRenderOffset = entityBullet.getOriginRenderOffset();
            Vec3 alphaCameraTranslation = originCameraPosition.m_82546_(cameraPosition);
            double distance = entityPosition.m_82554_(originCameraPosition);
            Vec3 bulletDirection = entityPosition.m_82546_(originCameraPosition);
            double yRot = MathUtil.getTwoVecAngle(new Vec3(0.0, 0.0, -1.0), new Vec3(bulletDirection.f_82479_, 0.0, bulletDirection.f_82481_));
            double xRot = MathUtil.getTwoVecAngle(new Vec3(bulletDirection.f_82479_, 0.0, bulletDirection.f_82481_), bulletDirection);
            if (yRot == -1.0) {
                yRot = Math.toRadians(camera.m_90590_() + 180.0f);
            }
            if (xRot == -1.0) {
                xRot = Math.toRadians(camera.m_90589_());
            }
            xRot *= bulletDirection.f_82480_ > 0.0 ? -1.0 : 1.0;
            double d = bulletDirection.f_82479_ > 0.0 ? 1.0 : -1.0;
            PoseStack poseStack1 = new PoseStack();
            poseStack1.m_252781_(Axis.f_252529_.m_252977_(camera.m_90589_()));
            poseStack1.m_252781_(Axis.f_252436_.m_252977_(camera.m_90590_() + 180.0f));
            poseStack1.m_85837_(alphaCameraTranslation.f_82479_, alphaCameraTranslation.f_82480_, alphaCameraTranslation.f_82481_);
            poseStack1.m_252781_(Axis.f_252392_.m_252961_((float)(yRot *= d)));
            poseStack1.m_252781_(Axis.f_252495_.m_252961_((float)xRot));
            poseStack1.m_85837_(originRenderOffset.f_82479_, originRenderOffset.f_82480_, originRenderOffset.f_82481_ - distance);
            float trailLength = 0.5f * (float)entityBullet.m_20184_().m_82553_();
            float trailWidth = 0.03f * entityBullet.getTracerSizeOverride();
            poseStack1.m_252880_(0.0f, 0.0f, -trailLength / 2.0f);
            poseStack1.m_85841_(trailWidth, trailWidth, trailLength);
            ResourceLocation gunId = entityBullet.getGunId();
            TimelessAPI.getClientGunIndex(gunId).ifPresent(gunIndex -> {
                float[] entityTracerColor = entityBullet.getTracerColorOverride().orElseGet(gunIndex::getTracerColor);
                if (entityTracerColor == null) {
                    ResourceLocation ammoId = entityBullet.getAmmoId();
                    TimelessAPI.getClientAmmoIndex(ammoId).ifPresent(ammoIndex -> {
                        float[] ammoTracerColor = ammoIndex.getTracerColor();
                        RenderType type = RenderType.m_110436_((ResourceLocation)InternalAssetLoader.DEFAULT_BULLET_TEXTURE, (float)15.0f, (float)15.0f);
                        model.render(poseStack1, ItemDisplayContext.NONE, type, LightTexture.m_109885_((int)15, (int)15), OverlayTexture.f_118083_, ammoTracerColor[0], ammoTracerColor[1], ammoTracerColor[2], 1.0f);
                    });
                } else {
                    RenderType type = RenderType.m_110436_((ResourceLocation)InternalAssetLoader.DEFAULT_BULLET_TEXTURE, (float)15.0f, (float)15.0f);
                    model.render(poseStack1, ItemDisplayContext.NONE, type, LightTexture.m_109885_((int)15, (int)15), OverlayTexture.f_118083_, entityTracerColor[0], entityTracerColor[1], entityTracerColor[2], 1.0f);
                }
            });
        }
    }

    @SubscribeEvent
    public static void cancelItemInHandViewBobbing(RenderItemInHandBobEvent.BobView event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        ItemStack itemStack = KeepingItemRenderer.getRenderer().getCurrentItem();
        if (IGun.getIGunOrNull(itemStack) != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onGunFire(GunFireEvent event) {
        if (event.getLogicalSide().isClient()) {
            LocalPlayer player;
            LivingEntity shooter = event.getShooter();
            if (!shooter.equals((Object)(player = Minecraft.m_91087_().f_91074_))) {
                return;
            }
            ItemStack mainhandItem = player.m_21205_();
            IGun iGun = IGun.getIGunOrNull(mainhandItem);
            if (iGun == null) {
                return;
            }
            TimelessAPI.getClientGunIndex(iGun.getGunId(mainhandItem)).ifPresent(gunIndex -> {
                shootTimeStamp = System.currentTimeMillis();
                MuzzleFlashRender.onShoot();
                if (gunIndex.getShellEjection() != null) {
                    ShellRender.addShell(gunIndex.getShellEjection().getRandomVelocity());
                }
            });
        }
    }

    private static boolean bulletFromPlayer(Entity entity) {
        if (entity instanceof EntityKineticBullet) {
            EntityKineticBullet entityBullet = (EntityKineticBullet)entity;
            return entityBullet.m_19749_() instanceof LocalPlayer;
        }
        return false;
    }

    private static void applyFirstPersonGunTransform(LocalPlayer player, ItemStack gunItemStack, ClientGunIndex gunIndex, PoseStack poseStack, BedrockGunModel model, float partialTicks) {
        float refitScreenOpeningProgress = REFIT_OPENING_DYNAMICS.update(RefitTransform.getOpeningProgress());
        float aimingProgress = AIMING_DYNAMICS.update(IClientPlayerGunOperator.fromLocalPlayer(player).getClientAimingProgress(partialTicks));
        FirstPersonRenderGunEvent.applyGunMovements(model, aimingProgress, partialTicks);
        FirstPersonRenderGunEvent.applyFirstPersonPositioningTransform(poseStack, model, gunItemStack, aimingProgress, refitScreenOpeningProgress);
        FirstPersonRenderGunEvent.applyAnimationConstraintTransform(poseStack, model, aimingProgress * (1.0f - refitScreenOpeningProgress));
    }

    private static void applyGunMovements(BedrockGunModel model, float aimingProgress, float partialTicks) {
        FirstPersonRenderGunEvent.applyShootSwayAndRotation(model, aimingProgress);
        FirstPersonRenderGunEvent.applyJumpingSway(model, partialTicks);
    }

    private static void applyFirstPersonPositioningTransform(PoseStack poseStack, BedrockGunModel model, ItemStack stack, float aimingProgress, float refitScreenOpeningProgress) {
        IGun iGun = IGun.getIGunOrNull(stack);
        if (iGun == null) {
            return;
        }
        Matrix4f transformMatrix = new Matrix4f();
        transformMatrix.identity();
        List<BedrockPart> idleNodePath = model.getIdleSightPath();
        List<BedrockPart> aimingNodePath = null;
        ResourceLocation scopeId = iGun.getAttachmentId(stack, AttachmentType.SCOPE);
        if (scopeId.equals((Object)DefaultAssets.EMPTY_ATTACHMENT_ID)) {
            scopeId = iGun.getBuiltInAttachmentId(stack, AttachmentType.SCOPE);
        }
        if (DefaultAssets.isEmptyAttachmentId(scopeId)) {
            aimingNodePath = model.getIronSightPath();
        } else {
            List<BedrockPart> scopeNodePath = model.getScopePosPath();
            if (scopeNodePath != null) {
                BedrockAttachmentModel attachmentModel;
                aimingNodePath = new ArrayList<BedrockPart>(scopeNodePath);
                Optional<ClientAttachmentIndex> indexOptional = TimelessAPI.getClientAttachmentIndex(scopeId);
                if (indexOptional.isPresent() && (attachmentModel = indexOptional.get().getAttachmentModel()) != null && attachmentModel.getScopeViewPath() != null) {
                    aimingNodePath.addAll(attachmentModel.getScopeViewPath());
                }
            }
        }
        MathUtil.applyMatrixLerp(transformMatrix, FirstPersonRenderGunEvent.getPositioningNodeInverse(idleNodePath), transformMatrix, 1.0f - refitScreenOpeningProgress);
        MathUtil.applyMatrixLerp(transformMatrix, FirstPersonRenderGunEvent.getPositioningNodeInverse(aimingNodePath), transformMatrix, (1.0f - refitScreenOpeningProgress) * aimingProgress);
        float refitTransformProgress = (float)Easing.easeOutCubic(RefitTransform.getTransformProgress());
        AttachmentType oldType = RefitTransform.getOldTransformType();
        AttachmentType currentType = RefitTransform.getCurrentTransformType();
        List<BedrockPart> fromNode = model.getRefitAttachmentViewPath(oldType);
        List<BedrockPart> toNode = model.getRefitAttachmentViewPath(currentType);
        MathUtil.applyMatrixLerp(transformMatrix, FirstPersonRenderGunEvent.getPositioningNodeInverse(fromNode), transformMatrix, refitScreenOpeningProgress);
        MathUtil.applyMatrixLerp(transformMatrix, FirstPersonRenderGunEvent.getPositioningNodeInverse(toNode), transformMatrix, refitScreenOpeningProgress * refitTransformProgress);
        poseStack.m_252880_(0.0f, 1.5f, 0.0f);
        poseStack.m_252931_(transformMatrix);
        poseStack.m_252880_(0.0f, -1.5f, 0.0f);
    }

    @Nonnull
    private static Matrix4f getPositioningNodeInverse(List<BedrockPart> nodePath) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.identity();
        if (nodePath != null) {
            for (int i = nodePath.size() - 1; i >= 0; --i) {
                BedrockPart part = nodePath.get(i);
                matrix4f.rotate((Quaternionfc)Axis.f_252495_.m_252961_(part.xRot));
                matrix4f.rotate((Quaternionfc)Axis.f_252392_.m_252961_(part.yRot));
                matrix4f.rotate((Quaternionfc)Axis.f_252393_.m_252961_(part.zRot));
                if (part.getParent() != null) {
                    matrix4f.translate(-part.x / 16.0f, -part.y / 16.0f, -part.z / 16.0f);
                    continue;
                }
                matrix4f.translate(-part.x / 16.0f, 1.5f - part.y / 16.0f, -part.z / 16.0f);
            }
        }
        return matrix4f;
    }

    private static void applyShootSwayAndRotation(BedrockGunModel model, float aimingProgress) {
        BedrockPart rootNode = model.getRootNode();
        if (rootNode != null) {
            float progress = 1.0f - (float)(System.currentTimeMillis() - shootTimeStamp) / 300.0f;
            if (progress < 0.0f) {
                progress = 0.0f;
            }
            progress = (float)Easing.easeOutCubic(progress);
            rootNode.offsetX += SHOOT_X_SWAY_NOISE.getValue() / 16.0f * progress * (1.0f - aimingProgress);
            rootNode.offsetY += 0.00625f * progress * (1.0f - aimingProgress);
            rootNode.additionalQuaternion.mul((Quaternionfc)Axis.f_252436_.m_252961_(SHOOT_Y_ROTATION_NOISE.getValue() * progress));
        }
    }

    private static void applyJumpingSway(BedrockGunModel model, float partialTicks) {
        LocalPlayer player;
        if (jumpingTimeStamp == -1L) {
            jumpingTimeStamp = System.currentTimeMillis();
        }
        if ((player = Minecraft.m_91087_().f_91074_) != null) {
            double posY = Mth.m_14139_((double)partialTicks, (double)Minecraft.m_91087_().f_91074_.f_19791_, (double)Minecraft.m_91087_().f_91074_.m_20186_());
            float velocityY = (float)(posY - Minecraft.m_91087_().f_91074_.f_19791_) / partialTicks;
            if (player.m_20096_()) {
                if (!lastOnGround) {
                    jumpingSwayProgress = velocityY / -0.1f;
                    if (jumpingSwayProgress > 1.0f) {
                        jumpingSwayProgress = 1.0f;
                    }
                    lastOnGround = true;
                } else if ((jumpingSwayProgress -= (float)(System.currentTimeMillis() - jumpingTimeStamp) / 150.0f) < 0.0f) {
                    jumpingSwayProgress = 0.0f;
                }
            } else if (lastOnGround) {
                jumpingSwayProgress = velocityY / 0.42f;
                if (jumpingSwayProgress > 1.0f) {
                    jumpingSwayProgress = 1.0f;
                }
                lastOnGround = false;
            } else if ((jumpingSwayProgress -= (float)(System.currentTimeMillis() - jumpingTimeStamp) / 300.0f) < 0.0f) {
                jumpingSwayProgress = 0.0f;
            }
        }
        jumpingTimeStamp = System.currentTimeMillis();
        float ySway = JUMPING_DYNAMICS.update(-2.0f * jumpingSwayProgress);
        BedrockPart rootNode = model.getRootNode();
        if (rootNode != null) {
            rootNode.offsetY += -ySway / 16.0f;
        }
    }

    private static void getAnimationConstraintTransform(List<BedrockPart> nodePath, @Nonnull Vector3f originTranslation, @Nonnull Vector3f animatedTranslation, @Nonnull Vector3f rotation) {
        if (nodePath == null) {
            return;
        }
        Matrix4f animeMatrix = new Matrix4f();
        Matrix4f originMatrix = new Matrix4f();
        animeMatrix.identity();
        originMatrix.identity();
        BedrockPart constrainNode = nodePath.get(nodePath.size() - 1);
        for (BedrockPart part : nodePath) {
            if (part != constrainNode) {
                animeMatrix.translate(part.offsetX, part.offsetY, part.offsetZ);
            }
            if (part.getParent() != null) {
                animeMatrix.translate(part.x / 16.0f, part.y / 16.0f, part.z / 16.0f);
            } else {
                animeMatrix.translate(part.x / 16.0f, part.y / 16.0f - 1.5f, part.z / 16.0f);
            }
            if (part != constrainNode) {
                animeMatrix.rotate((Quaternionfc)part.additionalQuaternion);
            }
            animeMatrix.rotate((Quaternionfc)Axis.f_252403_.m_252961_(part.zRot));
            animeMatrix.rotate((Quaternionfc)Axis.f_252436_.m_252961_(part.yRot));
            animeMatrix.rotate((Quaternionfc)Axis.f_252529_.m_252961_(part.xRot));
            if (part.getParent() != null) {
                originMatrix.translate(part.x / 16.0f, part.y / 16.0f, part.z / 16.0f);
            } else {
                originMatrix.translate(part.x / 16.0f, part.y / 16.0f - 1.5f, part.z / 16.0f);
            }
            originMatrix.rotate((Quaternionfc)Axis.f_252403_.m_252961_(part.zRot));
            originMatrix.rotate((Quaternionfc)Axis.f_252436_.m_252961_(part.yRot));
            originMatrix.rotate((Quaternionfc)Axis.f_252529_.m_252961_(part.xRot));
        }
        animeMatrix.getTranslation(animatedTranslation);
        originMatrix.getTranslation(originTranslation);
        Vector3f animatedRotation = MathUtil.getEulerAngles(animeMatrix);
        Vector3f originRotation = MathUtil.getEulerAngles(originMatrix);
        animatedRotation.sub((Vector3fc)originRotation);
        rotation.set(animatedRotation.x(), animatedRotation.y(), animatedRotation.z());
    }

    public static void applyAnimationConstraintTransform(PoseStack poseStack, BedrockGunModel gunModel, float weight) {
        List<BedrockPart> nodePath = gunModel.getConstraintPath();
        if (nodePath == null) {
            return;
        }
        if (gunModel.getConstraintObject() == null) {
            return;
        }
        Vector3f originTranslation = new Vector3f();
        Vector3f animatedTranslation = new Vector3f();
        Vector3f rotation = new Vector3f();
        Vector3f translationICA = gunModel.getConstraintObject().translationConstraint;
        Vector3f rotationICA = gunModel.getConstraintObject().rotationConstraint;
        FirstPersonRenderGunEvent.getAnimationConstraintTransform(nodePath, originTranslation, animatedTranslation, rotation);
        Vector3f inverseTranslation = new Vector3f((Vector3fc)originTranslation);
        inverseTranslation.sub((Vector3fc)animatedTranslation);
        inverseTranslation.mul(1.0f - translationICA.x(), 1.0f - translationICA.y(), 1.0f - translationICA.z());
        Vector3f inverseRotation = new Vector3f((Vector3fc)rotation);
        inverseRotation.mul(rotationICA.x() - 1.0f, rotationICA.y() - 1.0f, rotationICA.z() - 1.0f);
        poseStack.m_252880_(animatedTranslation.x(), animatedTranslation.y() + 1.5f, animatedTranslation.z());
        poseStack.m_252781_(Axis.f_252529_.m_252961_(inverseRotation.x() * weight));
        poseStack.m_252781_(Axis.f_252436_.m_252961_(inverseRotation.y() * weight));
        poseStack.m_252781_(Axis.f_252403_.m_252961_(inverseRotation.z() * weight));
        poseStack.m_252880_(-animatedTranslation.x(), -animatedTranslation.y() - 1.5f, -animatedTranslation.z());
        Matrix4f poseMatrix = poseStack.m_85850_().m_252922_();
        poseMatrix.m30(poseMatrix.m30() - inverseTranslation.x() * weight);
        poseMatrix.m31(poseMatrix.m31() - inverseTranslation.y() * weight);
        poseMatrix.m32(poseMatrix.m32() + inverseTranslation.z() * weight);
    }
}

