/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.event;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateMachine;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tacz")
public class TickAnimationEvent {
    @SubscribeEvent
    public static void tickAnimation(TickEvent.ClientTickEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        IClientPlayerGunOperator clientGunOperator = IClientPlayerGunOperator.fromLocalPlayer(player);
        ItemStack mainhandItem = player.m_21205_();
        Item item = mainhandItem.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        ResourceLocation gunId = iGun.getGunId(mainhandItem);
        TimelessAPI.getClientGunIndex(gunId).ifPresent(gunIndex -> {
            boolean isShooting;
            GunAnimationStateMachine animationStateMachine = gunIndex.getAnimationStateMachine();
            if (animationStateMachine == null) {
                return;
            }
            animationStateMachine.setAiming(clientGunOperator.getClientAimingProgress(1.0f) == 1.0f);
            boolean bl = isShooting = clientGunOperator.getClientShootCoolDown() > 0L;
            if (isShooting) {
                animationStateMachine.onShooterIdle();
            } else if (!player.m_108635_() && player.m_20142_()) {
                animationStateMachine.setOnGround(player.m_20096_()).onShooterRun(player.f_19787_);
            } else if (!player.m_108635_() && (double)player.f_108618_.m_108575_().m_165907_() > 0.01) {
                animationStateMachine.setOnGround(player.m_20096_()).onShooterWalk(player.f_108618_, player.f_19787_);
            } else {
                animationStateMachine.onShooterIdle();
            }
            Bolt boltType = gunIndex.getGunData().getBolt();
            int ammoCount = iGun.getCurrentAmmoCount(mainhandItem) + (iGun.hasBulletInBarrel(mainhandItem) && boltType != Bolt.OPEN_BOLT ? 1 : 0);
            if (ammoCount < 1) {
                animationStateMachine.onGunCatchBolt();
            } else {
                animationStateMachine.onGunReleaseBolt();
            }
            animationStateMachine.onIdleHoldingPose();
        });
    }
}

