/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.gameplay.LocalPlayerDataHolder;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.ClientMessagePlayerAim;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class LocalPlayerAim {
    private final LocalPlayerDataHolder data;
    private final LocalPlayer player;

    public LocalPlayerAim(LocalPlayerDataHolder data, LocalPlayer player) {
        this.data = data;
        this.player = player;
    }

    public void aim(boolean isAim) {
        ItemStack mainhandItem = this.player.m_21205_();
        Item item = mainhandItem.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        ResourceLocation gunId = iGun.getGunId(mainhandItem);
        TimelessAPI.getClientGunIndex(gunId).ifPresent(gunIndex -> {
            this.data.clientIsAiming = isAim;
            NetworkHandler.CHANNEL.sendToServer((Object)new ClientMessagePlayerAim(isAim));
        });
    }

    public float getClientAimingProgress(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)LocalPlayerDataHolder.oldAimingProgress, (float)this.data.clientAimingProgress);
    }

    public boolean isAim() {
        return this.data.clientIsAiming;
    }

    public boolean cancelSprint(LocalPlayer player, boolean pSprinting) {
        IGunOperator gunOperator = IGunOperator.fromLivingEntity((LivingEntity)player);
        boolean isAiming = gunOperator.getSynIsAiming();
        ReloadState.StateType reloadStateType = gunOperator.getSynReloadState().getStateType();
        if (isAiming || reloadStateType.isReloading() && !reloadStateType.isReloadFinishing()) {
            return false;
        }
        return pSprinting;
    }

    public void tickAimingProgress() {
        ItemStack mainhandItem = this.player.m_21205_();
        Item item = mainhandItem.m_41720_();
        if (!(item instanceof IGun)) {
            this.data.clientAimingProgress = 0.0f;
            LocalPlayerDataHolder.oldAimingProgress = 0.0f;
            return;
        }
        IGun iGun = (IGun)item;
        if (System.currentTimeMillis() - this.data.clientDrawTimestamp < 0L) {
            this.data.clientIsAiming = false;
        }
        ResourceLocation gunId = iGun.getGunId(mainhandItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresentOrElse(index -> {
            float alphaProgress = this.getAlphaProgress(index.getGunData());
            this.aimProgressCalculate(alphaProgress);
        }, () -> {
            this.data.clientAimingProgress = 0.0f;
            LocalPlayerDataHolder.oldAimingProgress = 0.0f;
        });
    }

    private void aimProgressCalculate(float alphaProgress) {
        LocalPlayerDataHolder.oldAimingProgress = this.data.clientAimingProgress;
        if (this.data.clientIsAiming) {
            this.data.clientAimingProgress += alphaProgress;
            if (this.data.clientAimingProgress > 1.0f) {
                this.data.clientAimingProgress = 1.0f;
            }
        } else {
            this.data.clientAimingProgress -= alphaProgress;
            if (this.data.clientAimingProgress < 0.0f) {
                this.data.clientAimingProgress = 0.0f;
            }
        }
        this.data.clientAimingTimestamp = System.currentTimeMillis();
    }

    private float getAlphaProgress(GunData gunData) {
        float aimTime = gunData.getAimTime();
        IGunOperator operator = IGunOperator.fromLivingEntity((LivingEntity)this.player);
        if (operator.getCacheProperty() != null) {
            aimTime = ((Float)operator.getCacheProperty().getCache("ads")).floatValue();
        }
        aimTime = Math.max(0.0f, aimTime);
        return (float)(System.currentTimeMillis() - this.data.clientAimingTimestamp + 1L) / (aimTime * 1000.0f);
    }
}

