/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource.loader.asset;

import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.client.animation.gltf.AnimationStructure;
import com.tacz.guns.client.resource.ClientAssetManager;
import com.tacz.guns.client.resource.ClientGunPackLoader;
import com.tacz.guns.client.resource.pojo.animation.bedrock.BedrockAnimationFile;
import com.tacz.guns.client.resource.pojo.animation.gltf.RawAnimationStructure;
import com.tacz.guns.util.TacPathVisitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class AnimationLoader {
    private static final Marker MARKER = MarkerManager.getMarker((String)"AnimationLoader");
    private static final Pattern GLTF_ANIMATION_PATTERN = Pattern.compile("^(\\w+)/animations/([\\w/]+)\\.gltf$");
    private static final Pattern BEDROCK_ANIMATION_PATTERN = Pattern.compile("^(\\w+)/animations/([\\w/]+)\\.animation\\.json$");

    public static boolean load(ZipFile zipFile, String zipPath) {
        Matcher bedrockMatcher;
        Matcher gltfMatcher = GLTF_ANIMATION_PATTERN.matcher(zipPath);
        if (gltfMatcher.find()) {
            String namespace = gltfMatcher.group(1);
            String path = gltfMatcher.group(2);
            ZipEntry entry = zipFile.getEntry(zipPath);
            if (entry == null) {
                GunMod.LOGGER.warn(MARKER, "{} file don't exist", (Object)zipPath);
                return false;
            }
            try (InputStream animationFileStream = zipFile.getInputStream(entry);){
                ResourceLocation registryName = new ResourceLocation(namespace, path);
                RawAnimationStructure rawStructure = (RawAnimationStructure)ClientGunPackLoader.GSON.fromJson((Reader)new InputStreamReader(animationFileStream, StandardCharsets.UTF_8), RawAnimationStructure.class);
                ClientAssetManager.INSTANCE.putGltfAnimation(registryName, new AnimationStructure(rawStructure));
            }
            catch (JsonIOException | JsonSyntaxException | IOException exception) {
                GunMod.LOGGER.warn(MARKER, "Failed to read animation file: {}, entry: {}", (Object)zipFile, (Object)entry);
                exception.printStackTrace();
            }
        }
        if ((bedrockMatcher = BEDROCK_ANIMATION_PATTERN.matcher(zipPath)).find()) {
            String namespace = bedrockMatcher.group(1);
            String path = bedrockMatcher.group(2);
            ZipEntry entry = zipFile.getEntry(zipPath);
            if (entry == null) {
                GunMod.LOGGER.warn(MARKER, "{} file don't exist", (Object)zipPath);
                return false;
            }
            try (InputStream animationFileStream = zipFile.getInputStream(entry);){
                ResourceLocation registryName = new ResourceLocation(namespace, path);
                BedrockAnimationFile bedrockAnimationFile = (BedrockAnimationFile)ClientGunPackLoader.GSON.fromJson((Reader)new InputStreamReader(animationFileStream, StandardCharsets.UTF_8), BedrockAnimationFile.class);
                ClientAssetManager.INSTANCE.putBedrockAnimation(registryName, bedrockAnimationFile);
            }
            catch (JsonIOException | JsonSyntaxException | IOException exception) {
                GunMod.LOGGER.warn(MARKER, "Failed to read animation file: {}, entry: {}", (Object)zipFile, (Object)entry);
                exception.printStackTrace();
            }
        }
        return false;
    }

    public static void load(File root) {
        Path animationPath = root.toPath().resolve("animations");
        if (Files.isDirectory(animationPath, new LinkOption[0])) {
            TacPathVisitor gltfVisitor = new TacPathVisitor(animationPath.toFile(), root.getName(), ".gltf", (id, file) -> {
                try (InputStream animationFileStream = Files.newInputStream(file, new OpenOption[0]);){
                    RawAnimationStructure rawStructure = (RawAnimationStructure)ClientGunPackLoader.GSON.fromJson((Reader)new InputStreamReader(animationFileStream, StandardCharsets.UTF_8), RawAnimationStructure.class);
                    ClientAssetManager.INSTANCE.putGltfAnimation((ResourceLocation)id, new AnimationStructure(rawStructure));
                }
                catch (IOException exception) {
                    GunMod.LOGGER.warn(MARKER, "Failed to read animation file: {}", file);
                    exception.printStackTrace();
                }
            });
            try {
                Files.walkFileTree(animationPath, gltfVisitor);
            }
            catch (JsonIOException | JsonSyntaxException | IOException exception) {
                GunMod.LOGGER.warn(MARKER, "Failed to walk file tree: {}", (Object)animationPath);
                exception.printStackTrace();
            }
            TacPathVisitor bedrockVisitor = new TacPathVisitor(animationPath.toFile(), root.getName(), ".animation.json", (id, file) -> {
                try (InputStream animationFileStream = Files.newInputStream(file, new OpenOption[0]);){
                    BedrockAnimationFile bedrockAnimationFile = (BedrockAnimationFile)ClientGunPackLoader.GSON.fromJson((Reader)new InputStreamReader(animationFileStream, StandardCharsets.UTF_8), BedrockAnimationFile.class);
                    ClientAssetManager.INSTANCE.putBedrockAnimation((ResourceLocation)id, bedrockAnimationFile);
                }
                catch (JsonIOException | JsonSyntaxException | IOException exception) {
                    GunMod.LOGGER.warn(MARKER, "Failed to read animation file: {}", file);
                    exception.printStackTrace();
                }
            });
            try {
                Files.walkFileTree(animationPath, bedrockVisitor);
            }
            catch (IOException e) {
                GunMod.LOGGER.warn(MARKER, "Failed to walk file tree: {}", (Object)animationPath);
                e.printStackTrace();
            }
        }
    }
}

