/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.command.sub;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.tacz.guns.GunMod;
import com.tacz.guns.client.resource.ClientReloadManager;
import com.tacz.guns.config.common.OtherConfig;
import com.tacz.guns.resource.DedicatedServerReloadManager;
import java.util.concurrent.TimeUnit;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.time.StopWatch;

public class ReloadCommand {
    private static final String RELOAD_NAME = "reload";

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder reload = Commands.m_82127_((String)RELOAD_NAME);
        reload.executes(ReloadCommand::reloadAllPack);
        return reload;
    }

    private static int reloadAllPack(CommandContext<CommandSourceStack> context) {
        StopWatch watch = StopWatch.createStarted();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ClientReloadManager::reloadAllPack);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> DedicatedServerReloadManager.reloadFromCommand(context));
        watch.stop();
        double time = (double)watch.getTime(TimeUnit.MICROSECONDS) / 1000.0;
        Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.m_213846_((Component)Component.m_237110_((String)"commands.tacz.reload.success", (Object[])new Object[]{time}));
            if (((Boolean)OtherConfig.DEFAULT_PACK_DEBUG.get()).booleanValue()) {
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"commands.tacz.reload.overwrite_off"));
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"commands.tacz.reload.overwrite_command.off"));
            } else {
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"commands.tacz.reload.overwrite_on"));
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"commands.tacz.reload.overwrite_command.on"));
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"commands.tacz.reload.backup"));
            }
        }
        GunMod.LOGGER.info("Model loading time: {} ms", (Object)time);
        return 1;
    }
}

