/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity.shooter;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.event.common.GunMeleeEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.entity.shooter.LivingEntityDrawGun;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.event.ServerMessageGunMelee;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.attachment.MeleeData;
import com.tacz.guns.resource.pojo.data.gun.GunDefaultMeleeData;
import com.tacz.guns.resource.pojo.data.gun.GunMeleeData;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;

public class LivingEntityMelee {
    private final LivingEntity shooter;
    private final ShooterDataHolder data;
    private final LivingEntityDrawGun draw;

    public LivingEntityMelee(LivingEntity shooter, ShooterDataHolder data, LivingEntityDrawGun draw) {
        this.shooter = shooter;
        this.data = data;
        this.draw = draw;
    }

    public void melee() {
        if (this.data.currentGunItem == null) {
            return;
        }
        if (this.draw.getDrawCoolDown() != 0L) {
            return;
        }
        if (this.data.boltCoolDown >= 0L) {
            return;
        }
        long coolDown = this.getMeleeCoolDown();
        if (coolDown != 0L) {
            return;
        }
        ItemStack currentGunItem = this.data.currentGunItem.get();
        if (MinecraftForge.EVENT_BUS.post((Event)new GunMeleeEvent(this.shooter, currentGunItem, LogicalSide.SERVER))) {
            return;
        }
        NetworkHandler.sendToTrackingEntity(new ServerMessageGunMelee(this.shooter.m_19879_(), currentGunItem), (Entity)this.shooter);
        Item item = currentGunItem.m_41720_();
        if (item instanceof AbstractGunItem) {
            AbstractGunItem logicGun = (AbstractGunItem)item;
            this.data.meleeTimestamp = System.currentTimeMillis();
            ResourceLocation muzzleId = logicGun.getAttachmentId(currentGunItem, AttachmentType.MUZZLE);
            MeleeData muzzleMeleeData = this.getMeleeData(muzzleId);
            if (muzzleMeleeData != null) {
                float prepTime = muzzleMeleeData.getPrepTime();
                this.data.meleePrepTickCount = (int)Math.max(0.0f, prepTime * 20.0f);
                return;
            }
            ResourceLocation stockId = logicGun.getAttachmentId(currentGunItem, AttachmentType.STOCK);
            MeleeData stockMeleeData = this.getMeleeData(stockId);
            if (stockMeleeData != null) {
                float prepTime = stockMeleeData.getPrepTime();
                this.data.meleePrepTickCount = (int)Math.max(0.0f, prepTime * 20.0f);
                return;
            }
            ResourceLocation gunId = logicGun.getGunId(currentGunItem);
            TimelessAPI.getCommonGunIndex(gunId).ifPresent(index -> {
                GunDefaultMeleeData defaultMeleeData = index.getGunData().getMeleeData().getDefaultMeleeData();
                if (defaultMeleeData == null) {
                    return;
                }
                float prepTime = defaultMeleeData.getPrepTime();
                this.data.meleePrepTickCount = (int)Math.max(0.0f, prepTime * 20.0f);
            });
        }
    }

    public void scheduleTickMelee() {
        if (this.data.meleePrepTickCount > 0) {
            --this.data.meleePrepTickCount;
            return;
        }
        if (this.data.meleePrepTickCount == 0) {
            this.data.meleePrepTickCount = -1;
            if (this.data.currentGunItem == null) {
                return;
            }
            ItemStack currentGunItem = this.data.currentGunItem.get();
            Item item = currentGunItem.m_41720_();
            if (item instanceof AbstractGunItem) {
                AbstractGunItem logicGun = (AbstractGunItem)item;
                logicGun.melee(this.shooter, currentGunItem);
            }
        }
    }

    public long getMeleeCoolDown() {
        if (this.data.currentGunItem == null) {
            return 0L;
        }
        ItemStack currentGunItem = this.data.currentGunItem.get();
        Item item = currentGunItem.m_41720_();
        if (!(item instanceof IGun)) {
            return 0L;
        }
        IGun iGun = (IGun)item;
        ResourceLocation gunId = iGun.getGunId(currentGunItem);
        Optional<CommonGunIndex> gunIndex = TimelessAPI.getCommonGunIndex(gunId);
        return gunIndex.map(index -> {
            GunMeleeData meleeData = index.getGunData().getMeleeData();
            ResourceLocation muzzleId = iGun.getAttachmentId(currentGunItem, AttachmentType.MUZZLE);
            MeleeData muzzleMeleeData = this.getMeleeData(muzzleId);
            if (muzzleMeleeData != null) {
                return this.getTotalCooldownTime(meleeData, muzzleMeleeData.getCooldown());
            }
            ResourceLocation stockId = iGun.getAttachmentId(currentGunItem, AttachmentType.STOCK);
            MeleeData stockMeleeData = this.getMeleeData(stockId);
            if (stockMeleeData != null) {
                return this.getTotalCooldownTime(meleeData, stockMeleeData.getCooldown());
            }
            GunDefaultMeleeData defaultMeleeData = meleeData.getDefaultMeleeData();
            float defaultMeleeCooldownTime = defaultMeleeData == null ? 0.0f : defaultMeleeData.getCooldown();
            return this.getTotalCooldownTime(meleeData, defaultMeleeCooldownTime);
        }).orElse(-1L);
    }

    private long getTotalCooldownTime(GunMeleeData meleeData, float extraCooldownTime) {
        float totalCooldownTime = meleeData.getCooldown() + extraCooldownTime;
        long coolDown = (long)(totalCooldownTime * 1000.0f) - (System.currentTimeMillis() - this.data.meleeTimestamp);
        if ((coolDown -= 5L) < 0L) {
            return 0L;
        }
        return coolDown;
    }

    @Nullable
    private MeleeData getMeleeData(ResourceLocation attachmentId) {
        if (DefaultAssets.isEmptyAttachmentId(attachmentId)) {
            return null;
        }
        return TimelessAPI.getCommonAttachmentIndex(attachmentId).map(index -> index.getData().getMeleeData()).orElse(null);
    }
}

