/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity.shooter;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.event.common.GunReloadEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.entity.shooter.LivingEntityDrawGun;
import com.tacz.guns.entity.shooter.LivingEntityShoot;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.event.ServerMessageGunReload;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunReloadData;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;

public class LivingEntityReload {
    private final LivingEntity shooter;
    private final ShooterDataHolder data;
    private final LivingEntityDrawGun draw;
    private final LivingEntityShoot shoot;

    public LivingEntityReload(LivingEntity shooter, ShooterDataHolder data, LivingEntityDrawGun draw, LivingEntityShoot shoot) {
        this.shooter = shooter;
        this.data = data;
        this.draw = draw;
        this.shoot = shoot;
    }

    public void reload() {
        if (this.data.currentGunItem == null) {
            return;
        }
        ItemStack currentGunItem = this.data.currentGunItem.get();
        Item item = currentGunItem.m_41720_();
        if (!(item instanceof AbstractGunItem)) {
            return;
        }
        AbstractGunItem gunItem = (AbstractGunItem)item;
        ResourceLocation gunId = gunItem.getGunId(currentGunItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(gunIndex -> {
            if (this.data.reloadStateType.isReloading()) {
                return;
            }
            if (this.shoot.getShootCoolDown() != 0L) {
                return;
            }
            if (this.draw.getDrawCoolDown() != 0L) {
                return;
            }
            if (this.data.boltCoolDown >= 0L) {
                return;
            }
            if (IGunOperator.fromLivingEntity(this.shooter).needCheckAmmo() && !gunItem.canReload(this.shooter, currentGunItem)) {
                return;
            }
            if (MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent(this.shooter, currentGunItem, LogicalSide.SERVER))) {
                return;
            }
            NetworkHandler.sendToTrackingEntity(new ServerMessageGunReload(this.shooter.m_19879_(), currentGunItem), (Entity)this.shooter);
            Bolt boltType = gunIndex.getGunData().getBolt();
            int ammoCount = gunItem.getCurrentAmmoCount(currentGunItem) + (gunItem.hasBulletInBarrel(currentGunItem) && boltType != Bolt.OPEN_BOLT ? 1 : 0);
            this.data.reloadStateType = ammoCount <= 0 ? ReloadState.StateType.EMPTY_RELOAD_FEEDING : ReloadState.StateType.TACTICAL_RELOAD_FEEDING;
            this.data.reloadTimestamp = System.currentTimeMillis();
        });
    }

    public ReloadState tickReloadState() {
        ReloadState reloadState = new ReloadState();
        reloadState.setStateType(ReloadState.StateType.NOT_RELOADING);
        reloadState.setCountDown(-1L);
        if (this.data.reloadTimestamp == -1L || this.data.currentGunItem == null) {
            return reloadState;
        }
        Item item = this.data.currentGunItem.get().m_41720_();
        if (!(item instanceof IGun)) {
            return reloadState;
        }
        IGun iGun = (IGun)item;
        ItemStack currentGunItem = this.data.currentGunItem.get();
        ResourceLocation gunId = iGun.getGunId(currentGunItem);
        Optional<CommonGunIndex> gunIndexOptional = TimelessAPI.getCommonGunIndex(gunId);
        if (gunIndexOptional.isEmpty()) {
            return reloadState;
        }
        GunData gunData = gunIndexOptional.get().getGunData();
        GunReloadData reloadData = gunData.getReloadData();
        long countDown = -1L;
        ReloadState.StateType stateType = this.data.reloadStateType;
        long progressTime = System.currentTimeMillis() - this.data.reloadTimestamp;
        if (stateType.isReloadingEmpty()) {
            feedTime = (long)(reloadData.getFeed().getEmptyTime() * 1000.0f);
            long finishingTime = (long)(reloadData.getCooldown().getEmptyTime() * 1000.0f);
            if (progressTime < feedTime) {
                stateType = ReloadState.StateType.EMPTY_RELOAD_FEEDING;
                countDown = feedTime - progressTime;
            } else if (progressTime < finishingTime) {
                stateType = ReloadState.StateType.EMPTY_RELOAD_FINISHING;
                countDown = finishingTime - progressTime;
            } else {
                stateType = ReloadState.StateType.NOT_RELOADING;
                this.data.reloadTimestamp = -1L;
            }
        } else if (stateType.isReloadingTactical()) {
            feedTime = (long)(reloadData.getFeed().getTacticalTime() * 1000.0f);
            long finishingTime = (long)(reloadData.getCooldown().getTacticalTime() * 1000.0f);
            if (progressTime < feedTime) {
                stateType = ReloadState.StateType.TACTICAL_RELOAD_FEEDING;
                countDown = feedTime - progressTime;
            } else if (progressTime < finishingTime) {
                stateType = ReloadState.StateType.TACTICAL_RELOAD_FINISHING;
                countDown = finishingTime - progressTime;
            } else {
                stateType = ReloadState.StateType.NOT_RELOADING;
                this.data.reloadTimestamp = -1L;
            }
        }
        if (this.data.reloadStateType == ReloadState.StateType.EMPTY_RELOAD_FEEDING && stateType == ReloadState.StateType.EMPTY_RELOAD_FINISHING && iGun instanceof AbstractGunItem) {
            AbstractGunItem abstractGunItem = (AbstractGunItem)iGun;
            if (this.data.currentGunItem != null) {
                abstractGunItem.doReload(this.shooter, currentGunItem, true);
            }
        }
        if (this.data.reloadStateType == ReloadState.StateType.TACTICAL_RELOAD_FEEDING && stateType == ReloadState.StateType.TACTICAL_RELOAD_FINISHING && iGun instanceof AbstractGunItem) {
            AbstractGunItem abstractGunItem = (AbstractGunItem)iGun;
            if (this.data.currentGunItem != null) {
                abstractGunItem.doReload(this.shooter, currentGunItem, false);
            }
        }
        this.data.reloadStateType = stateType;
        reloadState.setStateType(stateType);
        reloadState.setCountDown(countDown);
        return reloadState;
    }
}

