/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.item;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.builder.AmmoItemBuilder;
import com.tacz.guns.api.item.nbt.AmmoItemDataAccessor;
import com.tacz.guns.client.renderer.item.AmmoItemRenderer;
import com.tacz.guns.client.resource.ClientAssetManager;
import com.tacz.guns.client.resource.index.ClientAmmoIndex;
import com.tacz.guns.client.resource.pojo.PackInfo;
import com.tacz.guns.resource.index.CommonAmmoIndex;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public class AmmoItem
extends Item
implements AmmoItemDataAccessor {
    public AmmoItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public int getMaxStackSize(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IAmmo) {
            IAmmo iAmmo = (IAmmo)item;
            return TimelessAPI.getCommonAmmoIndex(iAmmo.getAmmoId(stack)).map(CommonAmmoIndex::getStackSize).orElse(1);
        }
        return 1;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Component m_7626_(@Nonnull ItemStack stack) {
        ResourceLocation ammoId = this.getAmmoId(stack);
        Optional<ClientAmmoIndex> ammoIndex = TimelessAPI.getClientAmmoIndex(ammoId);
        if (ammoIndex.isPresent()) {
            return Component.m_237115_((String)ammoIndex.get().getName());
        }
        return super.m_7626_(stack);
    }

    public static NonNullList<ItemStack> fillItemCategory() {
        NonNullList stacks = NonNullList.m_122779_();
        TimelessAPI.getAllCommonAmmoIndex().forEach(entry -> {
            ItemStack itemStack = AmmoItemBuilder.create().setId((ResourceLocation)entry.getKey()).build();
            stacks.add((Object)itemStack);
        });
        return stacks;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                Minecraft minecraft = Minecraft.m_91087_();
                return new AmmoItemRenderer(minecraft.m_167982_(), minecraft.m_167973_());
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag isAdvanced) {
        ResourceLocation ammoId = this.getAmmoId(stack);
        TimelessAPI.getClientAmmoIndex(ammoId).ifPresent(index -> {
            String tooltipKey = index.getTooltipKey();
            if (tooltipKey != null) {
                components.add((Component)Component.m_237115_((String)tooltipKey).m_130940_(ChatFormatting.GRAY));
            }
        });
        PackInfo packInfoObject = ClientAssetManager.INSTANCE.getPackInfo(ammoId);
        if (packInfoObject != null) {
            MutableComponent component = Component.m_237115_((String)packInfoObject.getName()).m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.ITALIC);
            components.add((Component)component);
        }
    }
}

