/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.modifier.custom;

import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.resource.CommonGunPackLoader;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.attachment.Modifier;
import com.tacz.guns.resource.pojo.data.gun.ExtraDamage;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EffectiveRangeModifier
implements IAttachmentModifier<Modifier, Float> {
    public static final String ID = "effective_range";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public JsonProperty<Modifier> readJson(String json) {
        Data data = (Data)CommonGunPackLoader.GSON.fromJson(json, Data.class);
        return new EffectiveRangeJsonProperty(data.getEffectiveRange());
    }

    @Override
    public CacheValue<Float> initCache(ItemStack gunItem, GunData gunData) {
        LinkedList<ExtraDamage.DistanceDamagePair> damageAdjust = null;
        if (gunData.getBulletData().getExtraDamage() != null) {
            damageAdjust = gunData.getBulletData().getExtraDamage().getDamageAdjust();
        }
        float effectiveRange = damageAdjust != null ? damageAdjust.get(0).getDistance() : 2.1474836E9f;
        return new CacheValue<Float>(Float.valueOf(effectiveRange));
    }

    @Override
    public void eval(List<Modifier> modifiers, CacheValue<Float> cache) {
        double eval = AttachmentPropertyManager.eval(modifiers, (double)cache.getValue().floatValue());
        cache.setValue(Float.valueOf((float)eval));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IAttachmentModifier.DiagramsData> getPropertyDiagramsData(ItemStack gunItem, GunData gunData, AttachmentCacheProperty cacheProperty) {
        float distanceModifier = ((Float)cacheProperty.getCache(ID)).floatValue();
        LinkedList<ExtraDamage.DistanceDamagePair> damageAdjust = null;
        if (gunData.getBulletData().getExtraDamage() != null) {
            damageAdjust = gunData.getBulletData().getExtraDamage().getDamageAdjust();
        }
        float effectiveRange = damageAdjust != null ? damageAdjust.get(0).getDistance() : 0.0f;
        float modifier = distanceModifier - effectiveRange;
        double percent = Math.min((double)effectiveRange / 100.0, 1.0);
        double modifierPercent = Math.min((double)modifier / 100.0, 1.0);
        String titleKey = "gui.tacz.gun_refit.property_diagrams.effective_range";
        String positivelyString = String.format("%.1fm \u00a7a(+%.1f)", Float.valueOf(effectiveRange), Float.valueOf(modifier));
        String negativelyString = String.format("%.1fm \u00a7c(%.1f)", Float.valueOf(effectiveRange), Float.valueOf(modifier));
        String defaultString = String.format("%.1fm", Float.valueOf(effectiveRange));
        boolean positivelyBetter = true;
        IAttachmentModifier.DiagramsData diagramsData = new IAttachmentModifier.DiagramsData(percent, modifierPercent, Float.valueOf(modifier), titleKey, positivelyString, negativelyString, defaultString, positivelyBetter);
        return Collections.singletonList(diagramsData);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getDiagramsDataSize() {
        return 1;
    }

    public static class Data {
        @SerializedName(value="effective_range")
        @Nullable
        private Modifier effectiveRange = null;

        @Nullable
        public Modifier getEffectiveRange() {
            return this.effectiveRange;
        }
    }

    public static class EffectiveRangeJsonProperty
    extends JsonProperty<Modifier> {
        public EffectiveRangeJsonProperty(Modifier value) {
            super(value);
        }

        @Override
        public void initComponents() {
            Modifier value = (Modifier)this.getValue();
            if (value != null) {
                double eval = AttachmentPropertyManager.eval(value, 25.0);
                if (eval > 25.0) {
                    this.components.add(Component.m_237115_((String)"tooltip.tacz.attachment.effective_range.increase").m_130940_(ChatFormatting.GREEN));
                } else if (eval < 25.0) {
                    this.components.add(Component.m_237115_((String)"tooltip.tacz.attachment.effective_range.decrease").m_130940_(ChatFormatting.RED));
                }
            }
        }
    }
}

