/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.entity;

import com.google.common.annotations.VisibleForTesting;
import corgitaco.enhancedcelestials.core.ECEntities;
import corgitaco.enhancedcelestials.entity.MeteorEntity;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MeteorStrikeEntity
extends Entity {
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(MeteorStrikeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> READY = SynchedEntityData.m_135353_(MeteorStrikeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int life;

    public MeteorStrikeEntity(EntityType<? extends MeteorStrikeEntity> $$0, Level level) {
        super($$0, level);
    }

    public MeteorStrikeEntity(Level level, Vec3 position, @Nullable Entity spawner) {
        super(ECEntities.METEOR_STRIKE.get(), level);
        this.m_146884_(position);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(READY, (Object)true);
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 position = this.m_20182_();
        if (!this.m_9236_().f_46443_ && this.isReady()) {
            if ((double)this.m_9236_().f_46441_.m_188501_() < 0.01) {
                float angle = this.m_9236_().f_46441_.m_188501_() * ((float)Math.PI * 2);
                float addedDistance = Mth.m_216267_((RandomSource)this.f_19796_, (float)2.0f, (float)(this.m_20205_() / 2.0f));
                double addX = Mth.m_14031_((float)angle) * addedDistance;
                double addZ = Mth.m_14089_((float)angle) * addedDistance;
                Vec3 meteorSpawnPos = position.m_82520_(addX, (double)Mth.m_216271_((RandomSource)this.f_19796_, (int)450, (int)500), addZ);
                MeteorEntity meteorEntity = new MeteorEntity(this.m_9236_());
                meteorEntity.m_146884_(meteorSpawnPos);
                meteorEntity.setSize(Mth.m_216267_((RandomSource)this.m_9236_().f_46441_, (float)0.3f, (float)3.0f));
                meteorEntity.m_20334_(0.0, -0.6, 0.0);
                this.m_9236_().m_7967_((Entity)meteorEntity);
            }
            if (this.life > 400) {
                this.m_146870_();
            }
            ++this.life;
        }
    }

    protected void m_7378_(CompoundTag compoundTag) {
        this.life = compoundTag.m_128451_("life");
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128405_("life", this.life);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public boolean isReady() {
        return (Boolean)this.f_19804_.m_135370_(READY);
    }

    public void setReady(boolean ready) {
        this.f_19804_.m_135381_(READY, (Object)ready);
    }

    public float getSize() {
        return Math.max(((Float)this.f_19804_.m_135370_(SIZE)).floatValue(), 1.0f);
    }

    @VisibleForTesting
    public void setSize(float pSize) {
        float i = Mth.m_14036_((float)pSize, (float)1.0f, (float)127.0f);
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(i));
        this.m_20090_();
        this.m_6210_();
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (SIZE.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return super.m_6972_(pPose).m_20388_(this.getSize() * 0.5f);
    }
}

