/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako;

import dev.buildtool.satako.Constants;
import dev.buildtool.satako.ItemHandler;
import dev.buildtool.satako.Methods;
import dev.buildtool.satako.clientside.ClientFunctions;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;

public final class Functions {
    public static BlockPos findAirAbove(WorldGenLevel serverWorld, BlockPos start) {
        while (!serverWorld.m_46859_(start) && (start = start.m_7494_()).m_123342_() >= 2 && start.m_123342_() <= serverWorld.m_141928_() - 2) {
        }
        return start;
    }

    public static BlockPos findAirBelow(WorldGenLevel serverWorld, BlockPos start) {
        while (!serverWorld.m_46859_(start) && (start = start.m_7495_()).m_123342_() >= 2 && start.m_123342_() <= serverWorld.m_141928_() - 2) {
        }
        return start;
    }

    public static boolean isPlayerInSurvivalMode(Player entityPlayer) {
        return !entityPlayer.m_5833_() && !entityPlayer.m_7500_();
    }

    public static boolean isSurvivalPlayer(Entity entity) {
        return entity instanceof Player && Functions.isPlayerInSurvival((Player)entity);
    }

    public static float getDefaultXRightLimbRotation(float limbSwing, float swingAmount) {
        return Mth.m_14089_((float)((float)((double)limbSwing + Math.PI))) * swingAmount;
    }

    public static float getDefaultXLeftLimbRotation(float limbSwing, float swingAmount) {
        return Mth.m_14089_((float)limbSwing) * swingAmount;
    }

    public static float getDefaultHeadYaw(float netYaw) {
        return netYaw * ((float)Math.PI / 180);
    }

    public static float getDefaultHeadPitch(float pitch) {
        return pitch * ((float)Math.PI / 180);
    }

    public static boolean isInSightOf(Entity watched, LivingEntity watcher, float angleRange) {
        float threshold;
        assert (angleRange <= 180.0f);
        Vec3 vecOne = new Vec3(watched.m_20185_() - watcher.m_20185_(), watched.m_20186_() + watched.m_20299_((float)1.0f).f_82480_ - watcher.m_20186_() - watcher.m_20299_((float)1.0f).f_82480_, watched.m_20189_() - watcher.m_20189_()).m_82541_();
        Vec3 vecTwo = watcher.m_20252_(1.0f).m_82541_();
        double dotproduct = vecTwo.m_82526_(vecOne);
        if (dotproduct > (double)(threshold = (180.0f - angleRange) / 180.0f)) {
            return watcher.m_142582_(watched);
        }
        return false;
    }

    public static BlockPos performBlockRayTrace(Entity from, double distance, Level world) {
        Vec3 eyesPosition = from.m_20299_(1.0f);
        Vec3 look = from.m_20154_();
        BlockPos blockPos = new BlockPos((int)eyesPosition.f_82479_, (int)eyesPosition.f_82480_, (int)eyesPosition.f_82481_);
        while (world.m_46859_(blockPos)) {
            eyesPosition = eyesPosition.m_82549_(look);
            blockPos = new BlockPos((int)eyesPosition.f_82479_, (int)eyesPosition.f_82480_, (int)eyesPosition.f_82481_);
            double dist = from.m_20275_(eyesPosition.f_82479_, eyesPosition.f_82480_, eyesPosition.f_82481_);
            if (!(dist >= distance * distance)) continue;
            break;
        }
        return blockPos;
    }

    public static boolean isThereSpaceInAHandler(IItemHandler iItemHandler, boolean allowPartialStack) {
        for (int i = 0; i < iItemHandler.getSlots(); ++i) {
            ItemStack itemStack = iItemHandler.getStackInSlot(i);
            if (!itemStack.m_41619_() && (!allowPartialStack || itemStack.m_41613_() >= itemStack.m_41741_())) continue;
            return true;
        }
        return false;
    }

    public static boolean isDirectionalBlockPowered(Direction blockDirection, BlockPos blockPosition, BlockPos pulsePosition, Level world) {
        BlockState backstate;
        Direction back = blockDirection.m_122424_();
        BlockPos backPosition = blockPosition.m_121945_(back);
        if (pulsePosition.equals((Object)backPosition) && (backstate = world.m_8055_(backPosition)).m_60803_()) {
            return world.m_276987_(backPosition, back);
        }
        return false;
    }

    public static Direction getPowerIncomingDirection(BlockPos pulsePosition, BlockPos target, Block notifier, Level world) {
        BlockState source = world.m_8055_(pulsePosition);
        for (Direction value : Direction.values()) {
            BlockState sidestate;
            BlockPos sidepos = target.m_121945_(value);
            if (!sidepos.equals((Object)pulsePosition) || (sidestate = world.m_8055_(sidepos)) != source || notifier != sidestate.m_60734_() || sidestate.m_60775_((BlockGetter)world, sidepos, value) <= 0) continue;
            return value;
        }
        return null;
    }

    public static int getDirectPower(BlockPos source, BlockPos target, Block notifier, Level world) {
        BlockState sourceState = world.m_8055_(source);
        for (Direction enumFacing : Direction.values()) {
            BlockState sidestate;
            BlockPos sidepos = target.m_121945_(enumFacing);
            if (!sidepos.equals((Object)source) || (sidestate = world.m_8055_(sidepos)) != sourceState || notifier != sidestate.m_60734_()) continue;
            return sidestate.m_60775_((BlockGetter)world, sidepos, enumFacing);
        }
        return 0;
    }

    public static boolean isNotifierAdjacent(BlockPos source, BlockPos target, Block notifier, Level world) {
        BlockState sourceState = world.m_8055_(source);
        for (Direction enumFacing : Direction.values()) {
            BlockState sidestate;
            BlockPos sidepos = target.m_121945_(enumFacing);
            if (!sidepos.equals((Object)source) || (sidestate = world.m_8055_(sidepos)) != sourceState || notifier != sidestate.m_60734_()) continue;
            return true;
        }
        return false;
    }

    public static BlockPos getBlockPositionFrom(ChunkPos chunkPos) {
        return new BlockPos(chunkPos.f_45578_ << 4, 0, chunkPos.f_45579_ << 4);
    }

    public static float degreesToRadians(float degrees) {
        return (float)((double)degrees * Math.PI / 180.0);
    }

    public static float translateToXcoord(float degrees) {
        if (degrees == 90.0f || degrees == -90.0f) {
            return 0.0f;
        }
        if (degrees == 180.0f || degrees == -180.0f) {
            return -1.0f;
        }
        return Mth.m_14089_((float)Functions.degreesToRadians(degrees));
    }

    public static float translateToZcoord(float degrees) {
        if (degrees == 90.0f || degrees == -90.0f) {
            return 1.0f;
        }
        if (degrees == 180.0f || degrees == -180.0f) {
            return 0.0f;
        }
        return Mth.m_14031_((float)Functions.degreesToRadians(degrees));
    }

    public static boolean canGenerateWithoutCascade(WorldGenLevel world, BlockPos blockPos) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        int cx = chunkPos.f_45578_;
        int cz = chunkPos.f_45579_;
        ChunkStatus empty = ChunkStatus.f_62314_;
        return world.m_6325_(cx, cz).m_6415_() != empty && world.m_6325_(cx + 1, cz).m_6415_() != empty && world.m_6325_(cx - 1, cz).m_6415_() != empty && world.m_6325_(cx, cz + 1).m_6415_() != empty && world.m_6325_(cx, cz - 1).m_6415_() != empty;
    }

    public static BlockPos getTopBlockPosition(BlockPos pos, Level world) {
        BlockPos blockpos = new BlockPos(pos.m_123341_(), world.m_141928_() - 16, pos.m_123343_());
        BlockState nextstate = world.m_8055_(blockpos);
        while (nextstate == Blocks.f_50016_.m_49966_()) {
            blockpos = blockpos.m_7495_();
            nextstate = world.m_8055_(blockpos);
        }
        return blockpos;
    }

    @Nullable
    public static Entity findEntityOnPath(Level world, Entity watcher) {
        Entity entity = null;
        Vec3 position = watcher.m_20299_(1.0f);
        Vec3 look = watcher.m_20154_();
        AABB axisAlignedBB = new AABB(new BlockPos((int)watcher.m_20185_(), (int)watcher.m_20186_(), (int)watcher.m_20189_())).m_82400_(7.0);
        List entities = world.m_45933_(watcher, axisAlignedBB);
        int counter = 0;
        block0: while (true) {
            position = position.m_82549_(look);
            for (Entity entity1 : entities) {
                if (!entity1.m_20191_().m_82390_(position)) continue;
                entity = entity1;
                break block0;
            }
            if (counter > 10) break;
            ++counter;
        }
        return entity;
    }

    public static boolean writeUUID(CompoundTag nbtTagCompound, String key, UUID uuid) {
        if (uuid != null && !uuid.equals(Constants.NULL_UUID)) {
            nbtTagCompound.m_128362_(key, uuid);
            return true;
        }
        return false;
    }

    public static UUID readUUID(CompoundTag nbtTagCompound, String key) {
        UUID uuid = nbtTagCompound.m_128342_(key);
        return uuid.equals(Constants.NULL_UUID) ? null : uuid;
    }

    public static int readEnum(CompoundTag compound, String key) {
        return compound.m_128445_(key);
    }

    public static boolean isLiquid(Level world, BlockPos pos) {
        FluidState fluidState = world.m_6425_(pos);
        Fluid fluid = fluidState.m_76152_();
        return fluid != Fluids.f_76191_;
    }

    public static boolean isFlowingLiquid(Level world, BlockPos position) {
        FluidState fluidState = world.m_6425_(position);
        Fluid fluid = fluidState.m_76152_();
        return fluid != Fluids.f_76191_ && !fluid.m_7444_(fluidState);
    }

    public static boolean isLiquidSource(Level world, BlockPos position) {
        FluidState fluidState = world.m_6425_(position);
        Fluid fluid = fluidState.m_76152_();
        return fluid != Fluids.f_76191_ && fluid.m_7444_(fluidState);
    }

    public static boolean isLookingAtHead(LivingEntity watcher, Entity target) {
        Vec3 lookvector = watcher.m_20252_(1.0f).m_82541_();
        Vec3 positionvector = new Vec3(target.m_20185_() - watcher.m_20185_(), watcher.m_20191_().f_82289_ + (double)target.m_20192_() - (watcher.m_20186_() + (double)watcher.m_20192_()), target.m_20189_() - watcher.m_20189_());
        double lengthVector = positionvector.m_82553_();
        double dotProduct = lookvector.m_82526_(positionvector = positionvector.m_82541_());
        if (dotProduct > 1.0 - 0.025 / lengthVector) {
            return watcher.m_142582_(target);
        }
        return false;
    }

    public static HashSet<BlockPos> getConnectedBlocks(Block of, Direction[] checkedSides, BlockPos pos, Level world, HashSet<BlockPos> positions, int limit) {
        assert (limit > 1) : "Limit must be >1";
        if (world.m_8055_(pos).m_60734_() == of) {
            positions.add(pos);
        }
        if (positions.size() >= limit) {
            return positions;
        }
        for (Direction checkedSide : checkedSides) {
            BlockPos side = pos.m_121945_(checkedSide);
            BlockState next = world.m_8055_(side);
            Block block = next.m_60734_();
            if (block != of) continue;
            if (!positions.contains(side)) {
                Functions.getConnectedBlocks(of, (Direction[])ArrayUtils.removeElement((Object[])Direction.values(), (Object)checkedSide.m_122424_()), side, world, positions, limit);
                continue;
            }
            positions.add(side);
            if (positions.size() < limit) continue;
            return positions;
        }
        return positions;
    }

    public static boolean isEmpty(Collection<ItemStack> itemStackCollection) {
        for (ItemStack itemStack : itemStackCollection) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static boolean isPlayerInSurvival(Player player) {
        return !player.m_7500_() && !player.m_5833_();
    }

    public static boolean isSuperClass(Class<?> subject, Object of) {
        if (of.getClass() == Class.class) {
            return subject.isAssignableFrom((Class)of);
        }
        return subject.isInstance(of);
    }

    public static List<BlockPos> boundingBoxToPositions(AABB axisAlignedBB) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (double X = axisAlignedBB.f_82288_; X <= axisAlignedBB.f_82291_; X += 1.0) {
            for (double Y = axisAlignedBB.f_82289_; Y <= axisAlignedBB.f_82292_; Y += 1.0) {
                for (double Z = axisAlignedBB.f_82290_; Z <= axisAlignedBB.f_82293_; Z += 1.0) {
                    positions.add(new BlockPos((int)X, (int)Y, (int)Z));
                }
            }
        }
        return positions;
    }

    public static Direction randomHorizontalFacing() {
        return Constants.HORIZONTALS[Methods.RANDOMGENERATOR.nextInt(Constants.HORIZONTALS.length)];
    }

    public static boolean canReplaceBlock(BlockPos blockPos, Level world) {
        BlockState iBlockState = world.m_8055_(blockPos);
        if (world.m_7702_(blockPos) != null) {
            return false;
        }
        return iBlockState.m_60800_((BlockGetter)world, blockPos) != -1.0f;
    }

    public static ItemEntity spawnItemInWorld(ItemStack itemStack, Level world, BlockPos pos) {
        if (world.f_46443_) {
            throw new IllegalArgumentException("Don't spawn items in client world");
        }
        ItemEntity entityItem = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, itemStack);
        world.m_7967_((Entity)entityItem);
        entityItem.m_20334_(0.0, 0.0, 0.0);
        return entityItem;
    }

    public static BlockPos getPosAboveSolidBlock(Level world, BlockPos blockPos) {
        blockPos = blockPos.m_6630_(world.m_141928_());
        BlockState blockState = world.m_8055_(blockPos);
        while (blockState.m_247087_() || blockState.m_60734_() instanceof LeavesBlock) {
            blockPos = blockPos.m_7495_();
            blockState = world.m_8055_(blockPos);
        }
        blockPos = blockPos.m_7494_();
        return blockPos;
    }

    public static ArrayList<Direction> getSideDirections(Direction of) {
        ArrayList<Direction> sidedirections = new ArrayList<Direction>(5);
        switch (of) {
            case DOWN: {
                Collections.addAll(sidedirections, Direction.UP, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH);
                break;
            }
            case UP: {
                Collections.addAll(sidedirections, Direction.DOWN, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH);
                break;
            }
            case EAST: {
                Collections.addAll(sidedirections, Direction.WEST, Direction.DOWN, Direction.UP, Direction.SOUTH, Direction.NORTH);
                break;
            }
            case WEST: {
                Collections.addAll(sidedirections, Direction.EAST, Direction.DOWN, Direction.UP, Direction.SOUTH, Direction.NORTH);
                break;
            }
            case SOUTH: {
                Collections.addAll(sidedirections, Direction.NORTH, Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST);
                break;
            }
            case NORTH: {
                Collections.addAll(sidedirections, Direction.SOUTH, Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST);
            }
        }
        return sidedirections;
    }

    public static boolean areItemTypesEqual(ItemStack one, ItemStack two) {
        if (!one.m_41619_() && !two.m_41619_()) {
            return ItemStack.m_150942_((ItemStack)one, (ItemStack)two);
        }
        return false;
    }

    public static boolean areItemsEqualIngoreNbt(ItemStack one, ItemStack two) {
        if (!one.m_41619_() && !two.m_41619_()) {
            return ItemStack.m_41656_((ItemStack)one, (ItemStack)two) && one.m_41773_() == two.m_41773_();
        }
        return false;
    }

    public static int getFuelValue(@Nonnull ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, null);
    }

    public static Direction isBlockDirectlyPowered(Level worldIn, BlockPos pos) {
        for (Direction from : Direction.values()) {
            int p;
            BlockPos sidepos = pos.m_121945_(from);
            BlockState sidestate = worldIn.m_8055_(sidepos);
            Block sideblock = sidestate.m_60734_();
            if (!sideblock.m_7899_(sidestate) || (p = sidestate.m_60775_((BlockGetter)worldIn, sidepos, from)) <= 0) continue;
            return from;
        }
        return null;
    }

    public static Direction isPoweredExceptSide(Direction side, Level world, BlockPos position) {
        for (Direction facing : Direction.values()) {
            int p;
            BlockPos sidepos;
            BlockState sidestate;
            Block sideblock;
            if (side == facing || !(sideblock = (sidestate = world.m_8055_(sidepos = position.m_121945_(facing))).m_60734_()).m_7899_(sidestate) || (p = sidestate.m_60775_((BlockGetter)world, sidepos, facing)) <= 0) continue;
            return facing;
        }
        return null;
    }

    public static int calculateLongestStringWidth(Collection<Component> objects) {
        int width = 0;
        for (Component s : objects) {
            int nextwidth = ClientFunctions.calculateStringWidth(s);
            if (nextwidth <= width) continue;
            width = nextwidth;
        }
        return width;
    }

    public static String getBlockName(BlockState blockState) {
        if (blockState.m_60734_() instanceof AirBlock) {
            return "Air";
        }
        ItemStack itemStack = new ItemStack((ItemLike)blockState.m_60734_(), 1);
        if (!itemStack.m_41619_()) {
            return itemStack.m_41611_().getString();
        }
        return blockState.m_60734_().m_7705_();
    }

    public static boolean removeHeldItem(Player player, Item item) {
        if (!player.m_21205_().m_41619_() && player.m_21205_().m_41720_() == item) {
            player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            return true;
        }
        if (!player.m_21206_().m_41619_() && player.m_21206_().m_41720_() == item) {
            player.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
            return true;
        }
        return false;
    }

    public static ItemStack getStackFromBlockState(BlockState blockState) {
        Item b;
        ItemStack ds = new ItemStack((ItemLike)blockState.m_60734_(), 1);
        if (ds.m_41619_() && !((b = Item.m_41439_((Block)blockState.m_60734_())) instanceof AirItem)) {
            ds = new ItemStack((ItemLike)b);
        }
        return ds;
    }

    public static Field getSecureField(Class<?> owner, int number) {
        Field[] fields = owner.getDeclaredFields();
        if (number < fields.length) {
            Field f = fields[number];
            if (f.getType() != owner.getEnclosingClass()) {
                f.setAccessible(true);
                return f;
            }
            return Functions.getSecureField(owner.getSuperclass(), number);
        }
        return null;
    }

    public static boolean isObfuscatedEnvironment() {
        return false;
    }

    public static Field getSecureField(Class<?> owningClass, String field) {
        Field f = null;
        try {
            f = owningClass.getDeclaredField(field);
            f.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            if (owningClass.getSuperclass() != null) {
                return Functions.getSecureField(owningClass.getSuperclass(), field);
            }
            System.err.println("Searched all super classes - field " + field + " not found");
        }
        return f;
    }

    public static Method getAnyMethod(Class<?> owner, String name, Class<?> ... parameterTypes) {
        Method m = null;
        try {
            m = owner.getDeclaredMethod(name, parameterTypes);
            m.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        return m;
    }

    public static Field getPublicField(Class<?> owner, String fieldName) {
        Field f = null;
        try {
            f = owner.getField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        return f;
    }

    public static ItemStack tryExtractItems(IItemHandler itemHandler, ItemStack itemStack, boolean simulate) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack presentstack = itemHandler.getStackInSlot(slot);
            if (!Functions.areItemTypesEqual(itemStack, presentstack)) continue;
            return itemHandler.extractItem(slot, itemStack.m_41613_(), simulate);
        }
        return ItemStack.f_41583_;
    }

    public static ItemHandler copyStacks(IItemHandler from) {
        ItemHandler itemHandler = new ItemHandler(from.getSlots());
        for (int i = 0; i < from.getSlots(); ++i) {
            ItemStack stack = from.extractItem(i, 64, true);
            if (stack.m_41619_() || Functions.tryInsertItem((IItemHandler)itemHandler, stack.m_41777_())) continue;
            System.out.println("Couldn't insert " + stack);
            return itemHandler;
        }
        return itemHandler;
    }

    public static boolean tryInsertItem(IItemHandler iItemHandler, ItemStack itemStack) {
        ItemStack out = ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)itemStack.m_41777_(), (boolean)false);
        itemStack.m_41764_(out.m_41613_());
        return out.m_41619_();
    }

    public static boolean canInsertItem(IItemHandler into, ItemStack stack) {
        int i;
        if (stack.m_41619_()) {
            return false;
        }
        int slots = into.getSlots();
        for (i = 0; i < slots; ++i) {
            ItemStack result;
            ItemStack pressent = into.getStackInSlot(i);
            if (!into.isItemValid(i, stack) || !Functions.areItemTypesEqual(stack, pressent) || !(result = into.insertItem(i, stack, true)).m_41619_()) continue;
            return true;
        }
        for (i = 0; i < slots; ++i) {
            ItemStack rem;
            ItemStack next = into.getStackInSlot(i);
            if (!next.m_41619_() || !into.isItemValid(i, stack) || !(rem = into.insertItem(i, stack, true)).m_41619_()) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isHolding(Predicate<Item> itemPredicate, LivingEntity entity) {
        return itemPredicate.test(entity.m_21205_().m_41720_()) || itemPredicate.test(entity.m_21206_().m_41720_());
    }

    public static int ticksToSeconds(int ticks) {
        return ticks / 20;
    }

    public static int ticksToMinutes(int ticks) {
        return Functions.ticksToSeconds(ticks) / 60;
    }

    public static int ticksToHours(int ticks) {
        return Functions.ticksToMinutes(ticks) / 60;
    }

    public static int secondsToTicks(int seconds) {
        return seconds * 20;
    }

    public static int minutesToTicks(int minutes) {
        return Functions.secondsToTicks(minutes) * 60;
    }

    public static int hoursToTicks(int hours) {
        return Functions.minutesToTicks(hours) * 60;
    }

    public static ItemStack getHeldItem(Player playerEntity, Item item) {
        if (playerEntity.m_21205_().m_41720_() == item) {
            return playerEntity.m_21205_();
        }
        if (playerEntity.m_21206_().m_41720_() == item) {
            return playerEntity.m_21206_();
        }
        return null;
    }

    public static ItemStack getHeldItem(Inventory playerInventory, Item item) {
        return Functions.getHeldItem(playerInventory.f_35978_, item);
    }

    public static InteractionHand getHandHoldingItem(Player playerEntity, Item item) {
        if (playerEntity.m_21205_().m_41720_() == item) {
            return InteractionHand.MAIN_HAND;
        }
        if (playerEntity.m_21206_().m_41720_() == item) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    public static int findItemIn(IItemHandler itemHandler, ItemStack stack) {
        int size = itemHandler.getSlots();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack nextstack = itemHandler.getStackInSlot(slot);
            if (!Functions.areItemTypesEqual(nextstack, stack)) continue;
            return slot;
        }
        return -1;
    }

    public static ItemStack searchItem(IItemHandler in, Item forItem) {
        for (int i = 0; i < in.getSlots(); ++i) {
            ItemStack itemStack = in.getStackInSlot(i);
            if (itemStack.m_41720_() != forItem) continue;
            return itemStack;
        }
        return null;
    }

    public static boolean removeBlock(BlockPos position, LevelAccessor world) {
        return world.m_7471_(position, false);
    }

    public static Rotation directionToRotation(Direction direction) {
        Rotation rotation;
        assert (direction.m_122434_().m_122479_());
        switch (direction) {
            case NORTH: {
                rotation = Rotation.NONE;
                break;
            }
            case SOUTH: {
                rotation = Rotation.CLOCKWISE_180;
                break;
            }
            case EAST: {
                rotation = Rotation.CLOCKWISE_90;
                break;
            }
            case WEST: {
                rotation = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
            default: {
                return null;
            }
        }
        return rotation.m_55952_(Rotation.COUNTERCLOCKWISE_90);
    }

    public static FriendlyByteBuf emptyBuffer() {
        return new FriendlyByteBuf(Unpooled.buffer());
    }

    public static boolean isBlockIn(Block block, TagKey<Block> tagKey) {
        return ForgeRegistries.BLOCKS.tags().getTag(tagKey).contains((Object)block);
    }

    public static boolean removeItems(Item type, int amount, Container container) {
        if (container.m_18947_(type) < amount) {
            return false;
        }
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack next = container.m_8020_(i);
            if (next.m_41720_() != type) continue;
            while (amount > 0) {
                next.m_41774_(1);
                --amount;
                if (!next.m_41619_()) continue;
            }
            if (amount != 0) continue;
            return true;
        }
        return true;
    }

    public static boolean removeItems(Item item, int amount, IItemHandler itemHandler) {
        ItemStack itemStack;
        int slot;
        int present = 0;
        for (slot = 0; slot < itemHandler.getSlots(); ++slot) {
            itemStack = itemHandler.getStackInSlot(slot);
            if (itemStack.m_41720_() == item) {
                present += itemStack.m_41613_();
            }
            if (present >= amount) break;
        }
        if (present < amount) {
            return false;
        }
        for (slot = 0; slot < itemHandler.getSlots(); ++slot) {
            itemStack = itemHandler.getStackInSlot(slot);
            if (itemStack.m_41720_() != item) continue;
            while (amount > 0) {
                itemStack.m_41774_(1);
                --amount;
                if (!itemStack.m_41619_()) continue;
            }
            if (amount != 0) continue;
            return true;
        }
        return true;
    }

    public static EntityType cast(EntityType<Entity> entityType) {
        return entityType;
    }

    public static Direction getLookDirectionOf(LivingEntity livingEntity) {
        if (livingEntity.m_146909_() > 45.0f) {
            return Direction.DOWN;
        }
        if (livingEntity.m_146909_() < -45.0f) {
            return Direction.UP;
        }
        return livingEntity.m_6350_();
    }

    public static boolean contains(Item item, IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack next = handler.getStackInSlot(i);
            if (!next.m_150930_(item)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack findItem(Item item, IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack next = handler.getStackInSlot(i);
            if (!next.m_150930_(item)) continue;
            return next;
        }
        return ItemStack.f_41583_;
    }
}

