/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako;

import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ItemHandler
extends ItemStackHandler {
    private BlockEntity owner;

    public ItemHandler(int size) {
        super(size);
    }

    public ItemHandler(int size, @Nullable BlockEntity tileEntity) {
        this(size);
        this.owner = tileEntity;
        this.stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
    }

    public ItemHandler(NonNullList<ItemStack> itemStacks) {
        super(itemStacks);
    }

    public NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (!stackInSlot.m_41619_()) {
            if (stackInSlot.m_41613_() >= Math.min(stackInSlot.m_41741_(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.m_41741_(), this.getSlotLimit(slot)) - stackInSlot.m_41613_();
            if (stack.m_41613_() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.m_41777_();
                    copy.m_41769_(stackInSlot.m_41613_());
                    this.setStackInSlot(slot, copy);
                    this.onContentsChanged(slot);
                }
                return ItemStack.f_41583_;
            }
            stack = stack.m_41777_();
            if (!simulate) {
                ItemStack copy = stack.m_41620_(m);
                copy.m_41769_(stackInSlot.m_41613_());
                this.setStackInSlot(slot, copy);
                this.onContentsChanged(slot);
            } else {
                stack.m_41774_(m);
            }
            return stack;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.m_41741_(), this.getSlotLimit(slot));
        if (m < stack.m_41613_()) {
            stack = stack.m_41777_();
            if (!simulate) {
                this.setStackInSlot(slot, stack.m_41620_(m));
                this.onContentsChanged(slot);
            } else {
                stack.m_41774_(m);
            }
            return stack;
        }
        if (!simulate) {
            this.setStackInSlot(slot, stack);
            this.onContentsChanged(slot);
        }
        return ItemStack.f_41583_;
    }

    public BlockEntity getOwner() {
        return this.owner;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.stacks) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    protected void onContentsChanged(int slot) {
        if (this.owner != null) {
            this.owner.m_6596_();
        }
    }

    public void setSize(int size) {
        NonNullList old = this.stacks;
        this.stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        for (int i = 0; i < Math.min(this.stacks.size(), old.size()); ++i) {
            this.stacks.set(i, (Object)((ItemStack)old.get(i)));
        }
    }
}

