/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.Options;
import dev.buildtool.satako.Promote;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public final class Methods {
    public static final Random RANDOMGENERATOR = new Random();

    public static void setBlocks(BlockPos from, BlockPos to, BlockState state, Level world) {
        Stream poss = BlockPos.m_121990_((BlockPos)from, (BlockPos)to);
        poss.forEach(blockPos -> world.m_46597_(blockPos, state));
    }

    public static void removeTileEntitySilently(BlockPos pos, Level world) {
        BlockEntity tileentity = world.m_7702_(pos);
        try {
            Field processingLoadedTiles = Functions.isObfuscatedEnvironment() ? Functions.getSecureField(Level.class, Options.processingLoadedTiles) : Functions.getSecureField(world.getClass(), "updatingBlockEntities");
            Field addedTileEntityList = Functions.isObfuscatedEnvironment() ? Functions.getSecureField(Level.class, Options.addedTileEntityList) : Functions.getSecureField(world.getClass(), "pendingBlockEntities");
            List atl = (List)addedTileEntityList.get(world);
            if (tileentity != null && processingLoadedTiles.getBoolean(world)) {
                tileentity.m_7651_();
                atl.remove(tileentity);
                world.m_46747_(pos);
            } else {
                if (tileentity != null) {
                    atl.remove(tileentity);
                    world.m_46747_(pos);
                }
                ChunkAccess chunk = world.m_46865_(pos);
                chunk.m_8114_(pos);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void sendBlockUpdate(ServerLevel worldServer, BlockPos blockPos) {
        BlockState blockState = worldServer.m_8055_(blockPos);
        worldServer.m_7260_(blockPos, blockState, blockState, 2);
    }

    public static void playSound(Level world, BlockPos blockPos, SoundEvent sound, float volume, float pitch) {
        world.m_7785_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), sound, null, volume, pitch, false);
    }

    public static void sendMessageToPlayer(Player player, String message) {
        player.m_5661_((Component)Component.m_237113_((String)message), false);
    }

    public static void show(Object[] objects) {
        System.out.println(Arrays.toString(objects));
    }

    public static void addPotionEffectNoParticles(LivingEntity entityLivingBase, MobEffect potion, int duration, int strength) {
        entityLivingBase.m_7292_(new MobEffectInstance(potion, duration, strength, false, false));
    }

    @Promote
    private static void transferItems(IItemHandler inputHandler, IItemHandler outputHandler, int byAmount) {
        block0: for (int i = 0; i < inputHandler.getSlots(); ++i) {
            int i1;
            ItemStack itemStack = inputHandler.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            for (i1 = 0; i1 < outputHandler.getSlots(); ++i1) {
                if (!outputHandler.isItemValid(i1, itemStack)) continue;
                ItemStack stack2 = outputHandler.getStackInSlot(i1);
                int min = Math.min(byAmount, itemStack.m_41613_());
                if (!Functions.areItemTypesEqual(itemStack, stack2) || stack2.m_41613_() + min > itemStack.m_41741_()) continue;
                itemStack.m_41774_(min);
                stack2.m_41769_(min);
                break block0;
            }
            for (i1 = 0; i1 < outputHandler.getSlots(); ++i1) {
                if (!outputHandler.isItemValid(i1, itemStack) || !outputHandler.getStackInSlot(i1).m_41619_()) continue;
                int min = Math.min(byAmount, itemStack.m_41613_());
                outputHandler.insertItem(i1, new ItemStack((ItemLike)itemStack.m_41720_(), min), false);
                itemStack.m_41774_(min);
                break block0;
            }
        }
    }

    public static void loadConfig(Pair<ForgeConfigSpec, ForgeConfigSpec> pair, String path) {
        String s = FMLPaths.CONFIGDIR.get().resolve(path).toString();
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(s)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        ((ForgeConfigSpec)pair.getRight()).setConfig((CommentedConfig)file);
    }
}

