/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.clientside;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.buildtool.satako.Constants;
import dev.buildtool.satako.IntegerColor;
import dev.buildtool.satako.clientside.ClientFunctions;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class ClientMethods {
    public static void addRectangle(VertexConsumer vertexConsumer, Matrix4f matrix4f, int x, int y, int z, float red, float green, float blue, float alpha, boolean addBackFaces, float extruder) {
        vertexConsumer.m_252986_(matrix4f, 0.0f, (float)(y + 1) + extruder, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix4f, 0.0f, (float)(y + 1) + extruder, (float)(z + 1)).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)(x + 1), (float)(y + 1) + extruder, (float)(z + 1)).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)(x + 1), (float)(y + 1) + extruder, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        if (addBackFaces) {
            vertexConsumer.m_252986_(matrix4f, (float)(1 + x), (float)(y + 1) + extruder, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            vertexConsumer.m_252986_(matrix4f, (float)(1 + x), (float)(y + 1) + extruder, (float)(1 + z)).m_85950_(red, green, blue, alpha).m_5752_();
            vertexConsumer.m_252986_(matrix4f, 0.0f, (float)(y + 1) + extruder, (float)(1 + z)).m_85950_(red, green, blue, alpha).m_5752_();
            vertexConsumer.m_252986_(matrix4f, 0.0f, (float)(y + 1) + extruder, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        }
        vertexConsumer.m_252986_(matrix4f, (float)(1 + x), -extruder, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)(1 + x), -extruder, (float)(1 + z)).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix4f, 0.0f, -extruder, (float)(1 + z)).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix4f, 0.0f, -extruder, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        if (addBackFaces) {
            vertexConsumer.m_252986_(matrix4f, 0.0f, -extruder, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            vertexConsumer.m_252986_(matrix4f, 0.0f, -extruder, (float)(1 + z)).m_85950_(red, green, blue, alpha).m_5752_();
            vertexConsumer.m_252986_(matrix4f, (float)(1 + x), -extruder, (float)(1 + z)).m_85950_(red, green, blue, alpha).m_5752_();
            vertexConsumer.m_252986_(matrix4f, (float)(1 + x), -extruder, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        }
        vertexConsumer.m_252986_(matrix4f, 0.0f, 0.0f, -extruder).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix4f, 0.0f, (float)(y + 1), -extruder).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)(x + 1), (float)(y + 1), -extruder).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)(x + 1), 0.0f, -extruder).m_85950_(red, green, blue, alpha).m_5752_();
        if (addBackFaces) {
            vertexConsumer.m_252986_(matrix4f, (float)(x + 1), 0.0f, -extruder).m_85950_(red, green, blue, alpha).m_5752_();
            vertexConsumer.m_252986_(matrix4f, (float)(x + 1), (float)(y + 1), -extruder).m_85950_(red, green, blue, alpha).m_5752_();
            vertexConsumer.m_252986_(matrix4f, 0.0f, (float)(y + 1), -extruder).m_85950_(red, green, blue, alpha).m_5752_();
            vertexConsumer.m_252986_(matrix4f, 0.0f, 0.0f, -extruder).m_85950_(red, green, blue, alpha).m_5752_();
        }
        vertexConsumer.m_252986_(matrix4f, (float)(x + 1), 0.0f, (float)(z + 1) + extruder).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)(x + 1), (float)(y + 1), (float)(z + 1) + extruder).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix4f, 0.0f, (float)(y + 1), (float)(z + 1) + extruder).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix4f, 0.0f, 0.0f, (float)(z + 1) + extruder).m_85950_(red, green, blue, alpha).m_5752_();
        if (addBackFaces) {
            vertexConsumer.m_252986_(matrix4f, 0.0f, 0.0f, (float)(z + 1) + extruder).m_85950_(red, green, blue, alpha).m_5752_();
            vertexConsumer.m_252986_(matrix4f, 0.0f, (float)(y + 1), (float)(z + 1) + extruder).m_85950_(red, green, blue, alpha).m_5752_();
            vertexConsumer.m_252986_(matrix4f, (float)(x + 1), (float)(y + 1), (float)(z + 1) + extruder).m_85950_(red, green, blue, alpha).m_5752_();
            vertexConsumer.m_252986_(matrix4f, (float)(x + 1), 0.0f, (float)(z + 1) + extruder).m_85950_(red, green, blue, alpha).m_5752_();
        }
        vertexConsumer.m_252986_(matrix4f, -extruder, 0.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -extruder, 0.0f, (float)(z + 1)).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -extruder, (float)(y + 1), (float)(z + 1)).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -extruder, (float)(y + 1), 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        if (addBackFaces) {
            vertexConsumer.m_252986_(matrix4f, -extruder, (float)(y + 1), 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            vertexConsumer.m_252986_(matrix4f, -extruder, (float)(y + 1), (float)(z + 1)).m_85950_(red, green, blue, alpha).m_5752_();
            vertexConsumer.m_252986_(matrix4f, -extruder, 0.0f, (float)(z + 1)).m_85950_(red, green, blue, alpha).m_5752_();
            vertexConsumer.m_252986_(matrix4f, -extruder, 0.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        }
        vertexConsumer.m_252986_(matrix4f, (float)(x + 1) + extruder, (float)(y + 1), 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)(x + 1) + extruder, (float)(y + 1), (float)(z + 1)).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)(x + 1) + extruder, 0.0f, (float)(z + 1)).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)(x + 1) + extruder, 0.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        if (addBackFaces) {
            vertexConsumer.m_252986_(matrix4f, (float)(x + 1) + extruder, 0.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            vertexConsumer.m_252986_(matrix4f, (float)(x + 1) + extruder, 0.0f, (float)(z + 1)).m_85950_(red, green, blue, alpha).m_5752_();
            vertexConsumer.m_252986_(matrix4f, (float)(x + 1) + extruder, (float)(y + 1), (float)(z + 1)).m_85950_(red, green, blue, alpha).m_5752_();
            vertexConsumer.m_252986_(matrix4f, (float)(x + 1) + extruder, (float)(y + 1), 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        }
    }

    private static void drawCircle(Tesselator tessellator) {
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_85815_);
        int num_segments = 16;
        float radius = 0.7f;
        for (int ii = 0; ii < num_segments; ++ii) {
            float theta = 6.283185f * (float)ii / (float)num_segments;
            float xx = radius * Mth.m_14089_((float)theta);
            float yy = radius * Mth.m_14031_((float)theta);
            bufferbuilder.m_5483_((double)xx, (double)yy, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        }
        tessellator.m_85914_();
    }

    private static void drawFilledCircle(Tesselator tessellator, float radius, IntegerColor color) {
        int circle_points = 50;
        float angle = 6.2832f / (float)circle_points;
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        double angle1 = 0.0;
        double xx = (double)radius * Math.cos(0.0);
        double yy = (double)radius * Math.sin(0.0);
        bufferBuilder.m_5483_(xx, yy, 0.0).m_85950_(color.getRed(), color.getGreen(), color.getBlue(), 255.0f).m_5752_();
        for (int i = 0; i < circle_points; ++i) {
            bufferBuilder.m_5483_((double)radius * Math.cos(angle1), (double)radius * Math.sin(angle1), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            angle1 += (double)angle;
        }
        tessellator.m_85914_();
    }

    public static void drawStringWithBackground(GuiGraphics matrixStack, Object obj, int x, int y, IntegerColor background) {
        String string = obj.toString();
        matrixStack.m_280488_(Minecraft.m_91087_().f_91062_, string, x + 2, y + 4, background.getIntColor());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openClientGui(Level world, Screen screen) {
        if (world.f_46443_) {
            Minecraft.m_91087_().m_91152_(screen);
        }
    }

    public static void drawCenteredString(GuiGraphics matrixStack, Component o, int X, int Y, IntegerColor color) {
        ClientMethods.drawString(matrixStack, o, X - ClientFunctions.calculateStringWidth(o) / 2, Y, color);
    }

    public static void drawCenteredStringWithShadow(GuiGraphics matrixStack, Component o, int X, int Y, IntegerColor color) {
        ClientMethods.drawStringWithShadow(matrixStack, o, X - ClientFunctions.calculateStringWidth(o) / 2, Y, color);
    }

    public static void drawString(GuiGraphics matrixStack, Object o, int X, int Y, IntegerColor color) {
        matrixStack.m_280488_(Minecraft.m_91087_().f_91062_, o.toString(), X, Y, color.getIntColor());
    }

    public static void drawStringWithShadow(GuiGraphics matrixStack, Object o, int X, int Y, IntegerColor color) {
        matrixStack.m_280488_(Minecraft.m_91087_().f_91062_, o.toString(), X, Y, color.getIntColor());
    }

    public static void drawTooltipLine(GuiGraphics guiGraphics, Component component, int popupX, int popupY, IntegerColor stringColor, IntegerColor backgroundColor, IntegerColor borderColor) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 399.0f);
        Font font = Minecraft.m_91087_().f_91062_;
        int stringWidth = font.m_92852_((FormattedText)component);
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)(popupX - stringWidth / 2), (int)(popupY - 4), (int)stringWidth, (int)14, (int)0, (int)backgroundColor.getIntColor(), (int)backgroundColor.getIntColor(), (int)borderColor.getIntColor(), (int)borderColor.getIntColor());
        guiGraphics.m_280653_(font, component, popupX, popupY - 1, stringColor.getIntColor());
        guiGraphics.m_280168_().m_85849_();
    }

    public static void drawTooltipLine(GuiGraphics guiGraphics, Component component, int x, int y) {
        ClientMethods.drawTooltipLine(guiGraphics, component, x, y, Constants.WHITE, Constants.GRAY, new IntegerColor(-990150));
    }

    public static void drawTooltipLines(GuiGraphics guiGraphics, List<MutableComponent> components, int x, int y) {
        List clientTooltipComponents = components.stream().map(component -> new ClientTextTooltip(component.m_7532_())).collect(Collectors.toList());
        int tooltipWidth = 0;
        int tooltipHeight = 0;
        Font font = Minecraft.m_91087_().f_91062_;
        for (ClientTooltipComponent clientTooltipComponent : clientTooltipComponents) {
            int n = clientTooltipComponent.m_142069_(font);
            if (n > tooltipWidth) {
                tooltipWidth = n;
            }
            tooltipHeight += clientTooltipComponent.m_142103_();
        }
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 401.0f);
        TooltipRenderUtil.m_280205_((GuiGraphics)guiGraphics, (int)x, (int)y, (int)tooltipWidth, (int)tooltipHeight, (int)0);
        int stringY = y;
        for (Component component2 : components) {
            guiGraphics.m_280430_(font, component2, x, stringY, Constants.WHITE.getIntColor());
            stringY += 10;
        }
    }

    public static void drawBackground(GuiGraphics graphics, int x, int y, int width, int height, IntegerColor color) {
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)graphics, (int)x, (int)y, (int)width, (int)height, (int)-1, (int)color.getIntColor(), (int)color.getIntColor(), (int)color.getIntColor(), (int)color.getIntColor());
    }
}

