/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.clientside;

import com.mojang.datafixers.util.Pair;
import dev.buildtool.satako.Satako;
import dev.buildtool.satako.clientside.ClientMethods;
import dev.buildtool.satako.integration.JEI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class TooltipHandler {
    static List<Component> originalTooltip;
    static List<MutableComponent> properties;
    public static ItemStack targetStack;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void tooltip(ItemTooltipEvent tooltipEvent) {
        originalTooltip = tooltipEvent.getToolTip();
    }

    public static void handle(ItemStack itemStack, GuiGraphics graphics) {
        if (((Boolean)Satako.enableInfoTooltip.get()).booleanValue()) {
            if (Screen.m_96639_()) {
                targetStack = itemStack;
                Item item = itemStack.m_41720_();
                Minecraft minecraft = Minecraft.m_91087_();
                Screen currentScreen = minecraft.f_91080_;
                if (currentScreen != null) {
                    Map enchantments;
                    int burnTime;
                    int enchantability;
                    int stacksize;
                    int durability;
                    ArrayList<Object> info = new ArrayList<Object>();
                    info.add(0, ForgeRegistries.ITEMS.getKey((Object)item).toString());
                    int repairCost = itemStack.m_41610_();
                    if (repairCost > 0) {
                        info.add("Repair cost: " + repairCost);
                    }
                    ClientLevel world = minecraft.f_91073_;
                    if (item instanceof MapItem) {
                        assert (world != null);
                        MapItemSavedData mapData = MapItem.m_42853_((ItemStack)itemStack, (Level)world);
                        if (mapData != null) {
                            byte scale = mapData.f_77890_;
                            info.add("Scale: " + scale + "/4");
                            info.add("Dimension: " + mapData.f_77887_.m_135782_().toString());
                        }
                    } else if (item instanceof BlockItem) {
                        int lightEmission;
                        BlockItem blockItem = (BlockItem)item;
                        Block block = blockItem.m_40614_();
                        BlockState defstate = block.m_49966_();
                        float friction = block.m_49958_();
                        if (friction != 0.6f) {
                            info.add("Slipperiness: " + friction);
                        }
                        if (ForgeRegistries.BLOCKS.tags().getTag(BlockTags.f_144282_).contains((Object)block)) {
                            info.add("Harvestable by " + ChatFormatting.YELLOW + "pickaxe");
                        }
                        if (ForgeRegistries.BLOCKS.tags().getTag(BlockTags.f_144280_).contains((Object)block)) {
                            info.add("Harvestable by " + ChatFormatting.YELLOW + "axe");
                        }
                        if (ForgeRegistries.BLOCKS.tags().getTag(BlockTags.f_144283_).contains((Object)block)) {
                            info.add("Harvestable by " + ChatFormatting.YELLOW + "shovel");
                        }
                        if (ForgeRegistries.BLOCKS.tags().getTag(BlockTags.f_144281_).contains((Object)block)) {
                            info.add("Harvestable by " + ChatFormatting.YELLOW + "hoe");
                        }
                        assert (world != null);
                        float hardness = defstate.m_60800_((BlockGetter)world, BlockPos.f_121853_);
                        if (hardness > 0.0f) {
                            info.add("Hardness: " + hardness);
                        } else if (hardness == -1.0f) {
                            info.add("Unbreakable");
                        }
                        float resistance = block.m_7325_();
                        if (resistance > 0.0f) {
                            float compRes = (resistance + 0.3f) * 0.3f;
                            if (compRes > 5.2f) {
                                info.add("Blast resistance: " + String.format("%.1f", Float.valueOf(resistance)) + " (TNT)");
                            } else if (compRes > 3.9f) {
                                info.add("Blast resistance: " + String.format("%.1f", Float.valueOf(resistance)) + " (Creeper)");
                            } else {
                                info.add("Blast resistance: " + String.format("%.1f", Float.valueOf(resistance)));
                            }
                        }
                        if (ForgeRegistries.BLOCKS.tags().getTag(BlockTags.f_13079_).contains((Object)defstate.m_60734_())) {
                            info.add("Can be used for Beacon");
                        }
                        if (defstate.isFlammable((BlockGetter)world, BlockPos.f_121853_, Direction.UP)) {
                            info.add("Flammable");
                        }
                        PushReaction pushReaction = defstate.m_60811_();
                        info.add("Push behavior: " + pushReaction);
                        if (defstate.m_155947_()) {
                            info.add("Has block entity");
                        }
                        if ((lightEmission = defstate.m_60791_()) > 0) {
                            info.add("Light: " + lightEmission);
                        }
                        if (defstate.m_60803_()) {
                            info.add("Redstone component");
                        }
                    } else if (item instanceof DiggerItem) {
                        DiggerItem toolItem = (DiggerItem)item;
                        Tier itemTier = toolItem.m_43314_();
                        float efficiency = itemTier.m_6624_();
                        int level = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44984_, (ItemStack)itemStack);
                        if (level > 0) {
                            efficiency += (float)(level * level + 1);
                        }
                        info.add("Speed: " + efficiency);
                        int harvestlevel = itemTier.m_6604_();
                        info.add("Harvest level: " + harvestlevel);
                    }
                    if (item instanceof SwordItem) {
                        SwordItem swordItem = (SwordItem)item;
                        float bane = EnchantmentHelper.m_44833_((ItemStack)itemStack, (MobType)MobType.f_21642_);
                        float smite = EnchantmentHelper.m_44833_((ItemStack)itemStack, (MobType)MobType.f_21641_);
                        if (bane > 0.0f || smite > 0.0f) {
                            float damage = swordItem.m_43299_();
                            info.add("Max. damage: " + ((bane > 0.0f ? damage + bane : smite + damage) + 1.0f));
                        }
                    }
                    if ((durability = itemStack.m_41776_()) > 0) {
                        info.add("Max. durability: " + durability);
                        int durabRemain = durability - itemStack.m_41773_();
                        if ((float)durabRemain / (float)durability <= 0.1f) {
                            info.add("Durability left: " + durabRemain);
                        }
                    }
                    if ((stacksize = itemStack.m_41741_()) == 1) {
                        info.add("Non-stackable");
                    } else if (stacksize != 64) {
                        info.add("Max. stack size: " + stacksize);
                    }
                    if (item.m_41472_()) {
                        FoodProperties foodStats = item.m_41473_();
                        assert (foodStats != null);
                        if (foodStats.m_38747_()) {
                            info.add("Always edible");
                        }
                        if (foodStats.m_38746_()) {
                            info.add("Suitable for wolves");
                        }
                        float nutrition = (float)foodStats.m_38744_() / 2.0f;
                        info.add("Restores " + nutrition + " hunger");
                        float saturation = foodStats.m_38745_();
                        info.add("Saturation: " + saturation);
                        List effects = foodStats.m_38749_();
                        if (!effects.isEmpty()) {
                            info.add(ChatFormatting.YELLOW + "Effects:");
                            for (Pair pair : effects) {
                                MobEffectInstance effectInstance = (MobEffectInstance)pair.getFirst();
                                info.add("   " + I18n.m_118938_((String)effectInstance.m_19576_(), (Object[])new Object[0]) + ":");
                                info.add("      Strength: " + effectInstance.m_19564_());
                                info.add("      Duration: " + effectInstance.m_19557_() / 20 + " s.");
                            }
                        }
                    }
                    if ((enchantability = itemStack.getEnchantmentValue()) > 0) {
                        info.add("Enchantability: " + enchantability);
                    }
                    if ((burnTime = ForgeHooks.getBurnTime((ItemStack)itemStack, null)) > 0) {
                        info.add("Burn time: " + burnTime + " (" + (float)burnTime / 200.0f + " items)");
                    }
                    if (PotionBrewing.m_43506_((ItemStack)itemStack)) {
                        info.add("Potion component");
                    }
                    if (!(enchantments = EnchantmentHelper.m_44831_((ItemStack)itemStack)).isEmpty()) {
                        for (Map.Entry integerEntry : enchantments.entrySet()) {
                            if (((Enchantment)integerEntry.getKey()).m_6586_() != ((Integer)integerEntry.getValue()).intValue() || (Integer)integerEntry.getValue() <= 1) continue;
                            info.add(I18n.m_118938_((String)((Enchantment)integerEntry.getKey()).m_44704_(), (Object[])new Object[0]) + " is maxed");
                        }
                    }
                    HashSet tags = new HashSet();
                    ForgeRegistries.ITEMS.tags().forEach(items -> {
                        if (items.contains((Object)item)) {
                            tags.add(items);
                        }
                    });
                    if (!tags.isEmpty()) {
                        info.add(ChatFormatting.AQUA + "Tags:");
                        tags.forEach(resourceLocation -> info.add("   " + resourceLocation.getKey().f_203868_()));
                    }
                    if (item instanceof SpawnEggItem) {
                        SpawnEggItem spawnEggItem = (SpawnEggItem)item;
                        EntityType entityType = spawnEggItem.m_43228_(null);
                        if (entityType.m_20672_()) {
                            info.add("Fire-immune");
                        }
                        MobCategory category = entityType.m_20674_();
                        info.add("Category: " + category.m_21607_());
                        if (category.m_21609_()) {
                            info.add("Friendly");
                        }
                        if (category.m_21610_()) {
                            info.add("Persistent");
                        }
                        info.add("Size: " + entityType.m_20678_() + "x" + entityType.m_20679_());
                        info.add("Id: " + ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType).toString());
                        if (entityType.getTags().count() > 0L) {
                            info.add(ChatFormatting.AQUA + "Tags:");
                            entityType.getTags().forEach(entityTypeTagKey -> info.add("  " + entityTypeTagKey.f_203868_()));
                        }
                    }
                    properties = info.stream().map(Component::m_237113_).toList();
                    if (Satako.jei && JEI.ingredientListOverlay != null) {
                        JEI.ingredientListOverlay.getIngredientUnderMouse().flatMap(ITypedIngredient::getItemStack).ifPresent(itemStack1 -> {
                            targetStack = itemStack1;
                        });
                    }
                }
            }
            TooltipHandler.renderHoveringTooltip(graphics);
        }
    }

    public static void renderHoveringTooltip(GuiGraphics graphics) {
        if (targetStack != null && Screen.m_96639_()) {
            Minecraft minecraft = Minecraft.m_91087_();
            Screen currentScreen = minecraft.f_91080_;
            if (!properties.isEmpty()) {
                int screenHeight;
                int tooltipY;
                int titleLinesCount;
                int theirLongestStringWidth = 0;
                for (Component iTextComponent : originalTooltip) {
                    String string = iTextComponent.getString();
                    int n = minecraft.f_91062_.m_92895_(string);
                    if (n <= theirLongestStringWidth) continue;
                    theirLongestStringWidth = n;
                }
                int ourLongestStringWidth = 0;
                for (Component component : properties) {
                    int xOffset = minecraft.f_91062_.m_92852_((FormattedText)component);
                    if (xOffset <= ourLongestStringWidth) continue;
                    ourLongestStringWidth = xOffset;
                }
                double mouseX = minecraft.f_91067_.m_91589_() * (double)minecraft.m_91268_().m_85445_() / (double)minecraft.m_91268_().m_85443_();
                int xOffset = (int)(mouseX - (double)ourLongestStringWidth) - 40;
                if (xOffset < 0) {
                    xOffset = 0;
                }
                double mouseY = minecraft.f_91067_.m_91594_() * (double)minecraft.m_91268_().m_85446_() / (double)minecraft.m_91268_().m_85444_();
                int tooltipTextWidth = 0;
                Font font = minecraft.f_91062_;
                for (Component component : properties) {
                    titleLinesCount = font.m_92852_((FormattedText)component);
                    if (titleLinesCount <= tooltipTextWidth) continue;
                    tooltipTextWidth = titleLinesCount;
                }
                boolean needsWrap = false;
                assert (currentScreen != null);
                int n = currentScreen.f_96543_;
                titleLinesCount = 1;
                int tooltipX = xOffset;
                if (tooltipX + tooltipTextWidth + 4 > n && (tooltipX = xOffset - 16 - tooltipTextWidth) < 4) {
                    tooltipTextWidth = xOffset > n / 2 ? xOffset - 12 - 8 : n - 16 - xOffset;
                    needsWrap = true;
                }
                if (needsWrap) {
                    tooltipY = 0;
                    ArrayList<FormattedText> wrappedTextLines = new ArrayList<FormattedText>();
                    for (screenHeight = 0; screenHeight < properties.size(); ++screenHeight) {
                        Component textLine = (Component)properties.get(screenHeight);
                        List wrappedLine = font.m_92865_().m_92414_((FormattedText)textLine, tooltipTextWidth, Style.f_131099_);
                        if (screenHeight == 0) {
                            titleLinesCount = wrappedLine.size();
                        }
                        for (FormattedText formattedText : wrappedLine) {
                            FormattedText line = formattedText;
                            int lineWidth = font.m_92852_(line);
                            if (lineWidth > tooltipY) {
                                tooltipY = lineWidth;
                            }
                            wrappedTextLines.add(line);
                        }
                    }
                    properties = wrappedTextLines.stream().map(iTextProperties -> Component.m_237113_((String)iTextProperties.getString())).collect(Collectors.toList());
                    tooltipX = xOffset > n / 2 ? xOffset - 16 - tooltipY : xOffset + 12;
                }
                tooltipY = (int)(mouseY - 12.0);
                int tooltipHeight = 8;
                if (properties.size() > 1) {
                    tooltipHeight += (properties.size() - 1) * 10;
                    if (properties.size() > titleLinesCount) {
                        tooltipHeight += 2;
                    }
                }
                screenHeight = currentScreen.f_96544_;
                if (tooltipY < 4) {
                    tooltipY = 4;
                } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
                    tooltipY = screenHeight - tooltipHeight - 4;
                }
                ClientMethods.drawTooltipLines(graphics, properties.stream().map(mutableComponent -> Component.m_237113_((String)mutableComponent.getString())).toList(), tooltipX, tooltipY);
            }
        }
    }

    @SubscribeEvent
    public static void event(ScreenEvent.Render.Post containerScreenEvent) {
        Screen containerScreen = containerScreenEvent.getScreen();
        if (containerScreen instanceof AbstractContainerScreen) {
            AbstractContainerScreen abstractContainerScreen = (AbstractContainerScreen)containerScreen;
            Slot slot = abstractContainerScreen.getSlotUnderMouse();
            if (slot != null) {
                targetStack = slot.m_7993_();
                TooltipHandler.handle(targetStack, containerScreenEvent.getGuiGraphics());
            }
            if (Satako.jei) {
                JEI.ingredientListOverlay.getIngredientUnderMouse().flatMap(ITypedIngredient::getItemStack).ifPresent(itemStack -> TooltipHandler.handle(itemStack, containerScreenEvent.getGuiGraphics()));
            }
        }
    }
}

