/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.clientside.gui;

import dev.buildtool.satako.clientside.gui.Hideable;
import dev.buildtool.satako.clientside.gui.Positionable;
import dev.buildtool.satako.clientside.gui.Scrollable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class BetterButton
extends ExtendedButton
implements Scrollable,
Positionable,
Hideable {
    public String string;
    public boolean verticalScroll;
    public boolean horizontalScroll;
    public int scrollingAmount;
    protected Font fontRenderer;

    public BetterButton(int x, int y, int width, int height, Component text, Button.OnPress pressable) {
        super(x, y, width, height, text, pressable);
        this.fontRenderer = Minecraft.m_91087_().f_91062_;
        this.scrollingAmount = this.f_93619_;
        this.string = text.getString();
    }

    public BetterButton(int x, int y, Component text) {
        this(x, y, Minecraft.m_91087_().f_91062_.m_92895_(text.getString()) + 8, 20, text, p_onPress_1_ -> {});
        this.string = text.getString();
    }

    public BetterButton(int x, int y, Component text, Button.OnPress onPress) {
        this(x, y, Minecraft.m_91087_().f_91062_.m_92895_(text.getString()) + 8, 20, text, onPress);
    }

    public BetterButton(int x, int y, Component text, boolean verticalScroll_, boolean horizontalScroll_) {
        this(x, y, text);
        this.verticalScroll = verticalScroll_;
        this.horizontalScroll = horizontalScroll_;
    }

    @Override
    public void scroll(int amount, boolean vertical) {
        if (vertical && this.verticalScroll) {
            this.setYPos((int)((float)this.getYPos() + Math.signum(amount) * (float)this.scrollingAmount));
        } else if (!vertical && this.horizontalScroll) {
            this.setXPos(this.getXPos() + amount);
        }
    }

    @Override
    public void setScrollable(boolean vertical, boolean b) {
        if (b) {
            if (vertical) {
                this.verticalScroll = true;
            } else {
                this.horizontalScroll = true;
            }
        } else if (vertical) {
            this.verticalScroll = false;
        } else {
            this.horizontalScroll = false;
        }
    }

    @Override
    public void setEnabled() {
        this.f_93623_ = true;
    }

    @Override
    public void setDisabled() {
        this.f_93623_ = false;
    }

    @Override
    public void setScrollAmount(int pixels) {
        this.scrollingAmount = pixels;
    }

    @Override
    public int getElementWidth() {
        return this.f_93618_;
    }

    @Override
    public int getElementHeight() {
        return this.f_93619_;
    }

    @Override
    public int getXPos() {
        return super.m_252754_();
    }

    @Override
    public void setXPos(int X) {
        super.m_252865_(X);
    }

    @Override
    public int getYPos() {
        return super.m_252907_();
    }

    @Override
    public void setYPos(int Y) {
        super.m_253211_(Y);
    }

    @Override
    public void setHidden(boolean hidden) {
        this.f_93624_ = !hidden;
    }
}

