/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.clientside.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import dev.buildtool.satako.Constants;
import dev.buildtool.satako.IntegerColor;
import dev.buildtool.satako.ItemHandlerSlot;
import dev.buildtool.satako.clientside.ClientMethods;
import dev.buildtool.satako.clientside.gui.DynamicTooltip;
import dev.buildtool.satako.clientside.gui.Page;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class ContainerScreen2<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    public static final int POPUP_SPACING = 22;
    protected int centerX;
    protected int centerY;
    protected ArrayList<Page> pages = new ArrayList(0);
    protected boolean drawBorders;
    public static int DEFAULT_POPUP_SHOW_TIME = 200;
    protected int popupPositionX;
    protected int popupPositionY;
    protected LinkedHashMap<Component, Integer> showTimes = new LinkedHashMap();
    protected HashMap<AbstractWidget, DynamicTooltip> tooltips = new HashMap();

    public ContainerScreen2(T container, Inventory playerInventory, Component name, boolean drawBorders_) {
        super(container, playerInventory, name);
        if (Minecraft.m_91087_().f_91080_ != null) {
            Minecraft.m_91087_().f_91080_ = null;
        }
        this.drawBorders = drawBorders_;
    }

    public void m_7856_() {
        int maxX = 0;
        int minX = this.getXSize();
        int maxY = 0;
        for (Slot slot : this.getSlots()) {
            int y;
            int x = slot.f_40220_;
            if (x > maxX) {
                maxX = x;
            }
            if (minX > x) {
                minX = x;
            }
            if ((y = slot.f_40221_) <= maxY) continue;
            maxY = y;
        }
        this.f_97726_ = maxX + 18;
        this.f_97727_ = maxY + 18;
        super.m_7856_();
        this.centerX = this.f_96543_ / 2;
        this.centerY = this.f_96544_ / 2;
        this.popupPositionX = this.centerX;
        this.popupPositionY = this.f_96544_ - 18;
    }

    protected List<Slot> getSlots() {
        return this.f_97732_.f_38839_;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float p_render_3_) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, p_render_3_);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        List<Slot> slots = this.getSlots();
        slots.stream().filter(Slot::m_6659_).forEach(slot -> {
            if (slot instanceof ItemHandlerSlot) {
                ItemHandlerSlot handlerSlot = (ItemHandlerSlot)((Object)slot);
                if (slot.m_7993_().m_41619_() && mouseX > slot.f_40220_ + this.f_97735_ && mouseX < slot.f_40220_ + this.f_97735_ + 18 && mouseY > slot.f_40221_ + this.f_97736_ && mouseY < slot.f_40221_ + this.f_97736_ + 18 && handlerSlot.tooltip != null) {
                    guiGraphics.m_280666_(this.f_96547_, ((ItemHandlerSlot)slot).tooltip, mouseX, mouseY);
                }
            }
        });
        this.tooltips.forEach((widget, tooltip) -> {
            if (widget.m_252754_() < mouseX && widget.m_252754_() + widget.m_5711_() > mouseX && mouseY > widget.m_252907_() && mouseY < widget.m_252907_() + widget.m_93694_()) {
                guiGraphics.m_280557_(this.f_96547_, tooltip.getTooltip(), mouseX, mouseY);
            }
        });
        int popupY = this.popupPositionY - (this.showTimes.keySet().size() - 1) * 22;
        for (Map.Entry<Component, Integer> entry : this.showTimes.entrySet()) {
            Component component = entry.getKey();
            Integer integer = entry.getValue();
            if (integer <= 0) continue;
            ClientMethods.drawTooltipLine(guiGraphics, component, this.popupPositionX, popupY);
            popupY += 22;
            Integer n = integer;
            integer = integer - 1;
            entry.setValue(integer);
        }
        this.showTimes.entrySet().removeIf(componentIntegerEntry -> (Integer)componentIntegerEntry.getValue() == 0);
    }

    protected void m_7286_(GuiGraphics matrixStack, float partialTicks, int mouseX, int mouseY) {
        List<Slot> slots = this.getSlots();
        GlStateManager._clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        slots.stream().filter(Slot::m_6659_).forEach(s -> {
            int sx = s.f_40220_;
            int sy = s.f_40221_;
            if (s instanceof ItemHandlerSlot) {
                ItemHandlerSlot itemHandlerSlot = (ItemHandlerSlot)((Object)s);
                if (itemHandlerSlot.getTexture() == null) {
                    matrixStack.m_280509_(sx + this.f_97735_, sy + this.f_97736_, sx + this.f_97735_ + 16, sy + this.f_97736_ + 16, itemHandlerSlot.getColor().getIntColor());
                } else {
                    matrixStack.m_280509_(sx + this.f_97735_, sy + this.f_97736_, sx + this.f_97735_ + 16, sy + this.f_97736_ + 16, -10066330);
                }
            } else {
                matrixStack.m_280509_(sx + this.f_97735_, sy + this.f_97736_, sx + this.f_97735_ + 16, sy + this.f_97736_ + 16, -10066330);
            }
        });
        IntegerColor color = Constants.BLUE;
        if (this.drawBorders) {
            int intColor = color.getIntColor();
            matrixStack.m_280656_(this.f_97735_ - 1, this.getXSize() + this.f_97735_ - 2, this.f_97736_ - 1, intColor);
            matrixStack.m_280656_(this.f_97735_, this.getXSize() + this.f_97735_ - 2, this.getYSize() + this.f_97736_ - 2, intColor);
            matrixStack.m_280315_(this.f_97735_ - 1, this.f_97736_ - 1, this.getYSize() + this.f_97736_ - 1, intColor);
            matrixStack.m_280315_(this.getXSize() + this.f_97735_ - 2, this.f_97736_ - 1, this.getYSize() + this.f_97736_ - 2, intColor);
        }
    }

    protected void m_280003_(GuiGraphics poseStack, int p1, int p2) {
        poseStack.m_280430_(this.f_96547_, this.f_96539_, this.f_97726_ / 2 - this.f_96547_.m_92895_(this.f_96539_.getString()) / 2, -14, Constants.ORANGE.getIntColor());
    }

    public boolean m_7979_(double p_97752_, double p_97753_, int p_97754_, double p_97755_, double p_97756_) {
        for (GuiEventListener child : this.m_6702_()) {
            child.m_7979_(p_97752_, p_97753_, p_97754_, p_97755_, p_97756_);
        }
        return super.m_7979_(p_97752_, p_97753_, p_97754_, p_97755_, p_97756_);
    }

    public void addPopup(Component message, int duration) {
        this.showTimes.put(message, duration);
    }

    public void addPopup(Component message) {
        this.addPopup(message, DEFAULT_POPUP_SHOW_TIME);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (GuiEventListener child : this.m_6702_()) {
            if (!child.m_6375_(mouseX, mouseY, button)) continue;
            if (button == 0) {
                this.m_7897_(true);
            }
            this.m_7522_(child);
            return true;
        }
        this.m_7522_(null);
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.m_7282_()) {
            this.m_7897_(false);
            if (this.m_7222_() != null) {
                return this.m_7222_().m_6348_(mouseX, mouseY, button);
            }
        }
        return super.m_6348_(mouseX, mouseY, button);
    }
}

