/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.clientside.gui;

import dev.buildtool.satako.Constants;
import dev.buildtool.satako.IntegerColor;
import dev.buildtool.satako.clientside.ClientMethods;
import dev.buildtool.satako.clientside.gui.BetterButton;
import dev.buildtool.satako.clientside.gui.Hideable;
import dev.buildtool.satako.clientside.gui.Scrollable;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class Label
extends BetterButton
implements Scrollable,
Hideable {
    protected boolean enabled;
    protected boolean verticalScroll;
    protected boolean horizontalScroll;
    protected boolean hidden;
    protected int scrollAmount = 20;
    protected Screen parent;
    protected IntegerColor backgroundColor;

    public Label(int x, int y, Component text, IntegerColor backgroundColor) {
        super(x, y, Minecraft.m_91087_().f_91062_.m_92895_(text.getString()), 10, text, null);
        this.backgroundColor = backgroundColor;
        if (backgroundColor != null) {
            this.m_252865_(x + 5);
            this.m_253211_(y + 5);
        }
    }

    public Label(int x, int y, Component text, @Nullable Screen parent, @Nullable Button.OnPress pressHandler, IntegerColor backgroundColor) {
        super(x, y, Minecraft.m_91087_().f_91062_.m_92895_(text.getString()), 10, text, pressHandler);
        this.parent = parent;
        this.backgroundColor = backgroundColor;
        if (backgroundColor != null) {
            this.m_252865_(x + 5);
            this.m_253211_(y + 5);
        }
    }

    public void m_5691_() {
        if (this.f_93717_ != null) {
            this.f_93717_.m_93750_((Button)this);
        }
    }

    public void m_87963_(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        if (!this.hidden) {
            if (this.backgroundColor != null) {
                ClientMethods.drawBackground(guiGraphics, this.m_252754_(), this.getYPos(), this.f_93618_, this.f_93619_, this.backgroundColor);
            }
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
            Label.m_280138_((GuiGraphics)guiGraphics, (Font)this.fontRenderer, (Component)this.m_6035_(), (int)this.getXPos(), (int)this.getYPos(), (int)(this.m_252754_() + this.m_5711_() - 4), (int)(this.getYPos() + this.m_93694_()), (int)Constants.WHITE.getIntColor());
        }
    }

    @Override
    public void scroll(int amount, boolean vertical) {
        if (vertical && this.verticalScroll) {
            this.setYPos((int)((float)this.getYPos() + Math.signum(amount) * (float)this.scrollAmount));
        } else if (!vertical && this.horizontalScroll) {
            this.setXPos(this.getXPos() + amount);
        }
    }

    @Override
    public void setScrollable(boolean vertical, boolean b) {
        if (vertical) {
            this.verticalScroll = b;
        } else {
            this.horizontalScroll = b;
        }
    }

    @Override
    public void setEnabled() {
        this.enabled = true;
    }

    @Override
    public void setDisabled() {
        this.enabled = false;
    }

    @Override
    public void setScrollAmount(int pixels) {
        this.scrollAmount = pixels;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public int m_5711_() {
        if (this.backgroundColor != null) {
            return this.getElementWidth() + 5;
        }
        return super.m_5711_();
    }

    public int m_252907_() {
        if (this.backgroundColor != null) {
            return super.m_252907_() - 5;
        }
        return super.m_252907_();
    }
}

