/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.clientside.gui;

import dev.buildtool.satako.clientside.ClientFunctions;
import dev.buildtool.satako.clientside.gui.Hideable;
import dev.buildtool.satako.clientside.gui.Positionable;
import dev.buildtool.satako.clientside.gui.Scrollable;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;

public class TextField
extends EditBox
implements Scrollable,
Positionable,
Hideable {
    public static final Predicate<String> POSITIVE_NUMBER = s -> s.isEmpty() || StringUtils.isNumeric((CharSequence)s);
    public boolean scrollable;
    private boolean enabled;
    protected int scrollAmount;

    public TextField(int X, int Y, Component text) {
        super(Minecraft.m_91087_().f_91062_, X, Y, ClientFunctions.calculateStringWidth(text) + 10, 15, text);
        this.scrollAmount = this.f_93619_;
        this.m_94164_(text.getString());
    }

    public TextField(int x, int y, Component string, int width) {
        this(x, y, string);
        this.m_93674_(width);
    }

    public TextField(int X, int Y, int width) {
        super(Minecraft.m_91087_().f_91062_, X, Y, width, 15, (Component)Component.m_237113_((String)""));
        this.scrollAmount = this.f_93619_;
    }

    public static TextField createWithMaxStringLength(int x_, int y_, int width, int maxStringLength, String string) {
        TextField textField = new TextField(x_, y_, width);
        textField.m_94199_(maxStringLength);
        textField.m_94164_(string);
        return textField;
    }

    @Override
    public void scroll(int amount, boolean vertical) {
        if (this.scrollable) {
            if (vertical) {
                this.setXPos(this.getXPos() + amount);
            } else {
                this.setYPos(this.getYPos() + amount);
            }
        }
    }

    @Override
    public void setScrollable(boolean vertical, boolean b) {
        this.scrollable = b;
    }

    @Override
    public void setEnabled() {
        this.enabled = true;
    }

    @Override
    public void setDisabled() {
        this.enabled = false;
    }

    @Override
    public void setScrollAmount(int pixels) {
        this.scrollAmount = pixels;
    }

    @Override
    public int getElementHeight() {
        return this.f_93619_;
    }

    @Override
    public int getXPos() {
        return super.m_252754_();
    }

    @Override
    public void setXPos(int X) {
        super.m_252865_(X);
    }

    @Override
    public int getYPos() {
        return super.m_252907_();
    }

    @Override
    public void setYPos(int Y) {
        this.setYPos(Y);
    }

    @Override
    public int getElementWidth() {
        return this.f_93618_;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.m_94194_(!hidden);
    }
}

