/*
 * Decompiled with CFR 0.152.
 */
package com.lunofe.xray_snitch;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.LocalDate;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkEvent;

public class Packet {
    private final String data;

    public Packet(String data) {
        this.data = data;
    }

    public static void encode(Packet msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.data);
    }

    public static Packet decode(FriendlyByteBuf buf) {
        return new Packet(buf.m_130136_(Short.MAX_VALUE));
    }

    private static void writeMessageToFile(ServerPlayer player, String message) {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path subDirPath = configPath.resolve("xray_snitch");
        File subDir = subDirPath.toFile();
        if (!subDir.exists()) {
            subDir.mkdirs();
        }
        File file = subDirPath.resolve(player.m_20148_() + ".txt").toFile();
        LocalDate currentDate = LocalDate.now();
        try {
            if (!file.exists() || !Files.readAllLines(file.toPath()).contains(currentDate + " | " + message)) {
                Files.write(file.toPath(), (currentDate + " | " + message + System.lineSeparator()).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class Handler {
        public static void handle(Packet msg, Supplier<NetworkEvent.Context> ctx) {
            NetworkEvent.Context context = ctx.get();
            context.enqueueWork(() -> {
                ServerPlayer player = context.getSender();
                if (player != null) {
                    Packet.writeMessageToFile(player, msg.data);
                }
            });
            context.setPacketHandled(true);
        }
    }
}

