/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.forge;

import io.github.foundationgames.automobility.AutomobilityClient;
import io.github.foundationgames.automobility.block.AutomobilityBlocks;
import io.github.foundationgames.automobility.block.model.SlopeBakedModel;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.forge.ForgePlatform;
import io.github.foundationgames.automobility.forge.block.render.ForgeSlopeBakedModel;
import io.github.foundationgames.automobility.particle.AutomobilityParticles;
import io.github.foundationgames.automobility.particle.DriftSmokeParticle;
import io.github.foundationgames.automobility.screen.AutomobileHud;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="automobility", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AutomobilityClientForge {
    @SubscribeEvent
    public static void initClient(FMLClientSetupEvent setup) {
        ForgePlatform.init();
        AutomobilityClient.init();
        SlopeBakedModel.impl = ForgeSlopeBakedModel::new;
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            Entity patt1836$temp = player.m_20202_();
            if (patt1836$temp instanceof AutomobileEntity) {
                AutomobileEntity auto = (AutomobileEntity)patt1836$temp;
                AutomobileHud.render(evt.getGuiGraphics(), (Player)player, auto, evt.getPartialTick());
            }
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> evt.setFOV(AutomobilityClient.modifyBoostFov(Minecraft.m_91087_(), evt.getFOV(), (float)evt.getPartialTick())));
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent evt) {
        evt.registerSpriteSet((ParticleType)AutomobilityParticles.DRIFT_SMOKE.require(), DriftSmokeParticle.Factory::new);
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block evt) {
        evt.register(AutomobilityClient.GRASS_COLOR, new Block[]{AutomobilityBlocks.GRASS_OFF_ROAD.require()});
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item evt) {
        evt.register(AutomobilityClient.GRASS_ITEM_COLOR, new ItemLike[]{(ItemLike)AutomobilityBlocks.GRASS_OFF_ROAD.require()});
    }
}

