/*
 * Decompiled with CFR 0.152.
 */
package tfar.warrior;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import tfar.warrior.WarriorClient;
import tfar.warrior.WarriorEntity;
import tfar.warrior.datagen.ModDatagen;

@Mod(value="warrior")
public class Warrior {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String MODID = "warrior";
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    static WeightedRandomList<WeightedEntry.Wrapper<Item>> randomList;

    public Warrior() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        if (FMLEnvironment.dist.isClient()) {
            WarriorClient.initClient(bus);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_SPEC);
        bus.addListener(this::register);
        bus.addListener(this::attribute);
        bus.addListener(this::readConfig);
        bus.addListener(ModDatagen::gather);
    }

    private void register(RegisterEvent e) {
        e.register(Registries.f_256939_, new ResourceLocation(MODID, MODID), () -> WarriorEntity.WARRIOR);
        e.register(Registries.f_256913_, new ResourceLocation(MODID, "warrior_spawn_egg"), () -> WarriorEntity.WARRIOR_SPAWN_EGG);
    }

    private void attribute(EntityAttributeCreationEvent e) {
        e.put(WarriorEntity.WARRIOR, Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 2.0).m_22266_(Attributes.f_22287_).m_22265_());
    }

    private void readConfig(ModConfigEvent e) {
        if (e.getConfig().getModId().equals(MODID)) {
            ArrayList<WeightedEntry.Wrapper> wrappers = new ArrayList<WeightedEntry.Wrapper>();
            for (String s : (List)ServerConfig.weapon_list.get()) {
                String[] strings = s.split("\\|");
                Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(strings[0]));
                int i = Integer.parseInt(strings[1]);
                wrappers.add(WeightedEntry.m_146290_((Object)item, (int)i));
            }
            randomList = WeightedRandomList.m_146328_(wrappers);
        }
    }

    static {
        Pair specPair2 = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair2.getRight();
        SERVER = (ServerConfig)specPair2.getLeft();
    }

    public static class ServerConfig {
        public static ForgeConfigSpec.ConfigValue<List<String>> weapon_list;
        public static final List<String> defaults;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("server");
            weapon_list = builder.comment("weighted list of spawned weapons [item|weight]").define("weapon_list", defaults);
            builder.pop();
        }

        static {
            defaults = Lists.newArrayList((Object[])new String[]{"crossbow|1", "bow|1", "iron_sword|1"});
        }
    }
}

