/*
 * Decompiled with CFR 0.152.
 */
package tfar.warrior;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import tfar.warrior.RangedXAttack;
import tfar.warrior.Warrior;

public class WarriorEntity
extends Zombie
implements CrossbowAttackMob {
    private final RangedBowAttackGoal<WarriorEntity> bowGoal = new RangedBowAttackGoal((Monster)this, 1.0, 20, 15.0f);
    private final RangedCrossbowAttackGoal<WarriorEntity> crossbowGoal = new RangedXAttack<WarriorEntity>(this, 1.0, 8.0f);
    private final MeleeAttackGoal meleeGoal = new MeleeAttackGoal((PathfinderMob)this, 1.2, false);
    private final TridentAttackGoal tridentGoal = new TridentAttackGoal((RangedAttackMob)this, 1.0, 40, 10.0f);
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(WarriorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final float CROSSBOW_POWER = 1.6f;
    public static final EntityType<WarriorEntity> WARRIOR = EntityType.Builder.m_20704_(WarriorEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f).m_20702_(8).m_20712_("warrior");
    public static final Item WARRIOR_SPAWN_EGG = new SpawnEggItem(WARRIOR, 10051392, 7643954, new Item.Properties());
    public static final TagKey<Biome> BIOMES = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("warrior", "warrior_spawns"));

    public WarriorEntity(EntityType<? extends WarriorEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Piglin.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractIllager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, true, living -> living.m_6336_() == MobType.f_21642_));
    }

    protected void m_6878_() {
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_CHARGING_CROSSBOW, (Object)false);
    }

    private boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CHARGING_CROSSBOW);
    }

    public void m_6136_(boolean pIsCharging) {
        this.f_19804_.m_135381_(DATA_IS_CHARGING_CROSSBOW, (Object)pIsCharging);
    }

    public void m_6504_(LivingEntity pTarget, float pDistanceFactor) {
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            this.shootBowProjectile(pTarget, pDistanceFactor);
        } else if (this.m_21205_().m_41720_() instanceof CrossbowItem) {
            this.m_32336_((LivingEntity)this, 1.6f);
        } else {
            this.throwTrident(pTarget, pDistanceFactor);
        }
    }

    public void shootBowProjectile(LivingEntity pTarget, float pDistanceFactor) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrow = this.getArrow(itemstack, pDistanceFactor);
        abstractarrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrow);
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.3333333333333333) - abstractarrow.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)abstractarrow);
    }

    public void throwTrident(LivingEntity pTarget, float pDistanceFactor) {
        ThrownTrident throwntrident = new ThrownTrident(this.m_9236_(), (LivingEntity)this, new ItemStack((ItemLike)Items.f_42713_));
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.3333333333333333) - throwntrident.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        throwntrident.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_11821_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)throwntrident);
    }

    protected AbstractArrow getArrow(ItemStack pArrowStack, float pVelocity) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)pArrowStack, (float)pVelocity);
    }

    public void m_5811_(LivingEntity pTarget, ItemStack pCrossbowStack, Projectile pProjectile, float pProjectileAngle) {
        this.m_32322_((LivingEntity)this, pTarget, pProjectile, pProjectileAngle, 1.6f);
    }

    public boolean m_5886_(ProjectileWeaponItem pProjectileWeapon) {
        return pProjectileWeapon == Items.f_42717_ || pProjectileWeapon == Items.f_42411_;
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason != MobSpawnType.STRUCTURE) {
            this.m_8061_(EquipmentSlot.MAINHAND, this.createSpawnWeapon());
        }
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.m_213946_(pLevel.m_213780_(), pDifficulty);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void reassessWeaponGoal() {
        if (!this.m_9236_().f_46443_) {
            this.f_21345_.m_25363_((Goal)this.meleeGoal);
            this.f_21345_.m_25363_(this.bowGoal);
            this.f_21345_.m_25363_(this.crossbowGoal);
            this.f_21345_.m_25363_((Goal)this.tridentGoal);
            ItemStack itemstack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem || item instanceof CrossbowItem || item instanceof TridentItem));
            if (itemstack.m_150930_(Items.f_42411_)) {
                int i = 20;
                if (this.m_9236_().m_46791_() != Difficulty.HARD) {
                    i = 40;
                }
                this.bowGoal.m_25797_(i);
                this.f_21345_.m_25352_(2, this.bowGoal);
            } else if (itemstack.m_150930_(Items.f_42717_)) {
                this.f_21345_.m_25352_(2, this.crossbowGoal);
            } else if (itemstack.m_150930_(Items.f_42713_)) {
                this.f_21345_.m_25352_(2, (Goal)this.tridentGoal);
            } else {
                this.f_21345_.m_25352_(2, (Goal)this.meleeGoal);
            }
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.reassessWeaponGoal();
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
        super.m_8061_(pSlot, pStack);
        if (!this.m_9236_().f_46443_) {
            this.reassessWeaponGoal();
        }
    }

    private ItemStack createSpawnWeapon() {
        Optional item = Warrior.randomList.m_216829_(this.f_19796_);
        ItemStack stack = new ItemStack((ItemLike)((WeightedEntry.Wrapper)item.get()).m_146310_());
        return stack;
    }

    public void m_6863_(boolean pChildZombie) {
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12043_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12046_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12045_;
    }

    protected SoundEvent m_7660_() {
        return SoundEvents.f_12047_;
    }

    public WarriorPose getArmPose() {
        if (this.isChargingCrossbow()) {
            return WarriorPose.CROSSBOW_CHARGE;
        }
        if (this.m_21093_(is -> is.m_41720_() instanceof CrossbowItem)) {
            boolean aggressive = this.m_5912_();
            return aggressive ? WarriorPose.CROSSBOW_HOLD : WarriorPose.CROSSBOW_HOLD_IDLE;
        }
        if (this.m_21093_(is -> is.m_41720_() instanceof BowItem)) {
            return WarriorPose.BOW_AND_ARROW;
        }
        if (this.m_21093_(is -> is.m_41720_() instanceof TridentItem)) {
            return WarriorPose.TRIDENT;
        }
        if (this.m_21093_(is -> !is.m_41619_())) {
            return this.m_5912_() ? WarriorPose.MELEE_ATTACK_WEAPON : WarriorPose.NEUTRAL;
        }
        return WarriorPose.MELEE_ATTACK;
    }

    static class TridentAttackGoal
    extends RangedAttackGoal {
        private final WarriorEntity drowned;

        public TridentAttackGoal(RangedAttackMob pRangedAttackMob, double pSpeedModifier, int pAttackInterval, float pAttackRadius) {
            super(pRangedAttackMob, pSpeedModifier, pAttackInterval, pAttackRadius);
            this.drowned = (WarriorEntity)pRangedAttackMob;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.drowned.m_21205_().m_150930_(Items.f_42713_);
        }

        public void m_8056_() {
            super.m_8056_();
            this.drowned.m_6672_(InteractionHand.MAIN_HAND);
        }

        public void m_8041_() {
            super.m_8041_();
            this.drowned.m_5810_();
        }
    }

    public static enum WarriorPose {
        MELEE_ATTACK,
        MELEE_ATTACK_WEAPON,
        BOW_AND_ARROW,
        CROSSBOW_HOLD_IDLE,
        CROSSBOW_HOLD,
        CROSSBOW_CHARGE,
        TRIDENT,
        NEUTRAL;

    }
}

